/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.DeviceCategory;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IDeviceCategoryRequest;
import java.util.List;

public class DeviceCategoryRequest
extends BaseRequest
implements IDeviceCategoryRequest {
    public DeviceCategoryRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceCategory.class);
    }

    @Override
    public void get(ICallback<? super DeviceCategory> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public DeviceCategory get() throws ClientException {
        return (DeviceCategory)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super DeviceCategory> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(DeviceCategory sourceDeviceCategory, ICallback<? super DeviceCategory> callback) {
        this.send(HttpMethod.PATCH, callback, sourceDeviceCategory);
    }

    @Override
    public DeviceCategory patch(DeviceCategory sourceDeviceCategory) throws ClientException {
        return (DeviceCategory)this.send(HttpMethod.PATCH, sourceDeviceCategory);
    }

    @Override
    public void post(DeviceCategory newDeviceCategory, ICallback<? super DeviceCategory> callback) {
        this.send(HttpMethod.POST, callback, newDeviceCategory);
    }

    @Override
    public DeviceCategory post(DeviceCategory newDeviceCategory) throws ClientException {
        return (DeviceCategory)this.send(HttpMethod.POST, newDeviceCategory);
    }

    @Override
    public void put(DeviceCategory newDeviceCategory, ICallback<? super DeviceCategory> callback) {
        this.send(HttpMethod.PUT, callback, newDeviceCategory);
    }

    @Override
    public DeviceCategory put(DeviceCategory newDeviceCategory) throws ClientException {
        return (DeviceCategory)this.send(HttpMethod.PUT, newDeviceCategory);
    }

    @Override
    public IDeviceCategoryRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceCategoryRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

