/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Device;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IDeviceWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class DeviceWithReferenceRequest
extends BaseRequest
implements IDeviceWithReferenceRequest {
    public DeviceWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Device.class);
    }

    @Override
    public void post(Device newDevice, IJsonBackedObject payload, ICallback<? super Device> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public Device post(Device newDevice, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newDevice;
        }
        return null;
    }

    @Override
    public void get(ICallback<? super Device> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Device get() throws ClientException {
        return (Device)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Device> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Device sourceDevice, ICallback<? super Device> callback) {
        this.send(HttpMethod.PATCH, callback, sourceDevice);
    }

    @Override
    public Device patch(Device sourceDevice) throws ClientException {
        return (Device)this.send(HttpMethod.PATCH, sourceDevice);
    }

    @Override
    public IDeviceWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

