/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DirectoryObjectGetByIdsBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetByIdsCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetByIdsCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetByIdsCollectionResponse;
import com.microsoft.graph.requests.extensions.IDirectoryObjectGetByIdsCollectionPage;
import com.microsoft.graph.requests.extensions.IDirectoryObjectGetByIdsCollectionRequest;
import java.util.List;

public class DirectoryObjectGetByIdsCollectionRequest
extends BaseCollectionRequest<DirectoryObjectGetByIdsCollectionResponse, IDirectoryObjectGetByIdsCollectionPage>
implements IDirectoryObjectGetByIdsCollectionRequest {
    protected final DirectoryObjectGetByIdsBody body = new DirectoryObjectGetByIdsBody();

    public DirectoryObjectGetByIdsCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObjectGetByIdsCollectionResponse.class, IDirectoryObjectGetByIdsCollectionPage.class);
    }

    @Override
    public void post(final ICallback<? super IDirectoryObjectGetByIdsCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DirectoryObjectGetByIdsCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryObjectGetByIdsCollectionPage post() throws ClientException {
        DirectoryObjectGetByIdsCollectionResponse response = (DirectoryObjectGetByIdsCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public IDirectoryObjectGetByIdsCollectionPage buildFromResponse(DirectoryObjectGetByIdsCollectionResponse response) {
        DirectoryObjectGetByIdsCollectionRequestBuilder builder = response.nextLink != null ? new DirectoryObjectGetByIdsCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null, null) : null;
        DirectoryObjectGetByIdsCollectionPage page = new DirectoryObjectGetByIdsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDirectoryObjectGetByIdsCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDirectoryObjectGetByIdsCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDirectoryObjectGetByIdsCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IDirectoryObjectGetByIdsCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IDirectoryObjectGetByIdsCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

