/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ListItemVersion;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IListItemVersionCollectionPage;
import com.microsoft.graph.requests.extensions.IListItemVersionCollectionRequest;
import com.microsoft.graph.requests.extensions.ListItemVersionCollectionPage;
import com.microsoft.graph.requests.extensions.ListItemVersionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ListItemVersionCollectionResponse;
import com.microsoft.graph.requests.extensions.ListItemVersionRequestBuilder;
import java.util.List;

public class ListItemVersionCollectionRequest
extends BaseCollectionRequest<ListItemVersionCollectionResponse, IListItemVersionCollectionPage>
implements IListItemVersionCollectionRequest {
    public ListItemVersionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ListItemVersionCollectionResponse.class, IListItemVersionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IListItemVersionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ListItemVersionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IListItemVersionCollectionPage get() throws ClientException {
        ListItemVersionCollectionResponse response = (ListItemVersionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ListItemVersion newListItemVersion, ICallback<? super ListItemVersion> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ListItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newListItemVersion, callback);
    }

    @Override
    public ListItemVersion post(ListItemVersion newListItemVersion) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ListItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newListItemVersion);
    }

    @Override
    public IListItemVersionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IListItemVersionCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IListItemVersionCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IListItemVersionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IListItemVersionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IListItemVersionCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IListItemVersionCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IListItemVersionCollectionPage buildFromResponse(ListItemVersionCollectionResponse response) {
        ListItemVersionCollectionRequestBuilder builder = response.nextLink != null ? new ListItemVersionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ListItemVersionCollectionPage page = new ListItemVersionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

