/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedAppRegistration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedAppRegistrationCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedAppRegistrationCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionResponse;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationRequestBuilder;
import java.util.List;

public class ManagedAppRegistrationCollectionRequest
extends BaseCollectionRequest<ManagedAppRegistrationCollectionResponse, IManagedAppRegistrationCollectionPage>
implements IManagedAppRegistrationCollectionRequest {
    public ManagedAppRegistrationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedAppRegistrationCollectionResponse.class, IManagedAppRegistrationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IManagedAppRegistrationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ManagedAppRegistrationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedAppRegistrationCollectionPage get() throws ClientException {
        ManagedAppRegistrationCollectionResponse response = (ManagedAppRegistrationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedAppRegistration newManagedAppRegistration, ICallback<? super ManagedAppRegistration> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedAppRegistrationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedAppRegistration, callback);
    }

    @Override
    public ManagedAppRegistration post(ManagedAppRegistration newManagedAppRegistration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedAppRegistrationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedAppRegistration);
    }

    @Override
    public IManagedAppRegistrationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IManagedAppRegistrationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IManagedAppRegistrationCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IManagedAppRegistrationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IManagedAppRegistrationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IManagedAppRegistrationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IManagedAppRegistrationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IManagedAppRegistrationCollectionPage buildFromResponse(ManagedAppRegistrationCollectionResponse response) {
        ManagedAppRegistrationCollectionRequestBuilder builder = response.nextLink != null ? new ManagedAppRegistrationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedAppRegistrationCollectionPage page = new ManagedAppRegistrationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

