/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedAppStatus;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedAppStatusCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedAppStatusCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedAppStatusCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedAppStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedAppStatusCollectionResponse;
import com.microsoft.graph.requests.extensions.ManagedAppStatusRequestBuilder;
import java.util.List;

public class ManagedAppStatusCollectionRequest
extends BaseCollectionRequest<ManagedAppStatusCollectionResponse, IManagedAppStatusCollectionPage>
implements IManagedAppStatusCollectionRequest {
    public ManagedAppStatusCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedAppStatusCollectionResponse.class, IManagedAppStatusCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IManagedAppStatusCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ManagedAppStatusCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedAppStatusCollectionPage get() throws ClientException {
        ManagedAppStatusCollectionResponse response = (ManagedAppStatusCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedAppStatus newManagedAppStatus, ICallback<? super ManagedAppStatus> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedAppStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedAppStatus, callback);
    }

    @Override
    public ManagedAppStatus post(ManagedAppStatus newManagedAppStatus) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedAppStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedAppStatus);
    }

    @Override
    public IManagedAppStatusCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IManagedAppStatusCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IManagedAppStatusCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IManagedAppStatusCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IManagedAppStatusCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IManagedAppStatusCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IManagedAppStatusCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IManagedAppStatusCollectionPage buildFromResponse(ManagedAppStatusCollectionResponse response) {
        ManagedAppStatusCollectionRequestBuilder builder = response.nextLink != null ? new ManagedAppStatusCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedAppStatusCollectionPage page = new ManagedAppStatusCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

