/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedMobileLobApp;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedMobileLobAppCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedMobileLobAppCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedMobileLobAppCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedMobileLobAppCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedMobileLobAppCollectionResponse;
import com.microsoft.graph.requests.extensions.ManagedMobileLobAppRequestBuilder;
import java.util.List;

public class ManagedMobileLobAppCollectionRequest
extends BaseCollectionRequest<ManagedMobileLobAppCollectionResponse, IManagedMobileLobAppCollectionPage>
implements IManagedMobileLobAppCollectionRequest {
    public ManagedMobileLobAppCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedMobileLobAppCollectionResponse.class, IManagedMobileLobAppCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IManagedMobileLobAppCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ManagedMobileLobAppCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedMobileLobAppCollectionPage get() throws ClientException {
        ManagedMobileLobAppCollectionResponse response = (ManagedMobileLobAppCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedMobileLobApp newManagedMobileLobApp, ICallback<? super ManagedMobileLobApp> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedMobileLobAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedMobileLobApp, callback);
    }

    @Override
    public ManagedMobileLobApp post(ManagedMobileLobApp newManagedMobileLobApp) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedMobileLobAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedMobileLobApp);
    }

    @Override
    public IManagedMobileLobAppCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IManagedMobileLobAppCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IManagedMobileLobAppCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IManagedMobileLobAppCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IManagedMobileLobAppCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IManagedMobileLobAppCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IManagedMobileLobAppCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IManagedMobileLobAppCollectionPage buildFromResponse(ManagedMobileLobAppCollectionResponse response) {
        ManagedMobileLobAppCollectionRequestBuilder builder = response.nextLink != null ? new ManagedMobileLobAppCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedMobileLobAppCollectionPage page = new ManagedMobileLobAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

