/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.extensions.Message;
import com.microsoft.graph.models.extensions.Recipient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.IMessageCreateForwardRequest;
import com.microsoft.graph.requests.extensions.IMessageCreateForwardRequestBuilder;
import com.microsoft.graph.requests.extensions.MessageCreateForwardRequest;
import java.util.List;

public class MessageCreateForwardRequestBuilder
extends BaseActionRequestBuilder
implements IMessageCreateForwardRequestBuilder {
    public MessageCreateForwardRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, List<Recipient> toRecipients, Message message, String comment) {
        super(requestUrl, client, requestOptions);
        this.bodyParams.put("toRecipients", toRecipients);
        this.bodyParams.put("message", message);
        this.bodyParams.put("comment", comment);
    }

    @Override
    public IMessageCreateForwardRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Override
    public IMessageCreateForwardRequest buildRequest(List<? extends Option> requestOptions) {
        MessageCreateForwardRequest request = new MessageCreateForwardRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        if (this.hasParameter("toRecipients")) {
            request.body.toRecipients = (List)this.getParameter("toRecipients");
        }
        if (this.hasParameter("message")) {
            request.body.message = (Message)this.getParameter("message");
        }
        if (this.hasParameter("comment")) {
            request.body.comment = (String)this.getParameter("comment");
        }
        return request;
    }
}

