/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Participant;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IParticipantRequest;
import java.util.List;

public class ParticipantRequest
extends BaseRequest
implements IParticipantRequest {
    public ParticipantRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Participant.class);
    }

    @Override
    public void get(ICallback<? super Participant> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Participant get() throws ClientException {
        return (Participant)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Participant> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Participant sourceParticipant, ICallback<? super Participant> callback) {
        this.send(HttpMethod.PATCH, callback, sourceParticipant);
    }

    @Override
    public Participant patch(Participant sourceParticipant) throws ClientException {
        return (Participant)this.send(HttpMethod.PATCH, sourceParticipant);
    }

    @Override
    public void post(Participant newParticipant, ICallback<? super Participant> callback) {
        this.send(HttpMethod.POST, callback, newParticipant);
    }

    @Override
    public Participant post(Participant newParticipant) throws ClientException {
        return (Participant)this.send(HttpMethod.POST, newParticipant);
    }

    @Override
    public void put(Participant newParticipant, ICallback<? super Participant> callback) {
        this.send(HttpMethod.PUT, callback, newParticipant);
    }

    @Override
    public Participant put(Participant newParticipant) throws ClientException {
        return (Participant)this.send(HttpMethod.PUT, newParticipant);
    }

    @Override
    public IParticipantRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IParticipantRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

