/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ProfilePhoto;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IProfilePhotoCollectionPage;
import com.microsoft.graph.requests.extensions.IProfilePhotoCollectionRequest;
import com.microsoft.graph.requests.extensions.ProfilePhotoCollectionPage;
import com.microsoft.graph.requests.extensions.ProfilePhotoCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ProfilePhotoCollectionResponse;
import com.microsoft.graph.requests.extensions.ProfilePhotoRequestBuilder;
import java.util.List;

public class ProfilePhotoCollectionRequest
extends BaseCollectionRequest<ProfilePhotoCollectionResponse, IProfilePhotoCollectionPage>
implements IProfilePhotoCollectionRequest {
    public ProfilePhotoCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ProfilePhotoCollectionResponse.class, IProfilePhotoCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IProfilePhotoCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ProfilePhotoCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IProfilePhotoCollectionPage get() throws ClientException {
        ProfilePhotoCollectionResponse response = (ProfilePhotoCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ProfilePhoto newProfilePhoto, ICallback<? super ProfilePhoto> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ProfilePhotoRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newProfilePhoto, callback);
    }

    @Override
    public ProfilePhoto post(ProfilePhoto newProfilePhoto) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ProfilePhotoRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newProfilePhoto);
    }

    @Override
    public IProfilePhotoCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IProfilePhotoCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IProfilePhotoCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IProfilePhotoCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IProfilePhotoCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IProfilePhotoCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IProfilePhotoCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IProfilePhotoCollectionPage buildFromResponse(ProfilePhotoCollectionResponse response) {
        ProfilePhotoCollectionRequestBuilder builder = response.nextLink != null ? new ProfilePhotoCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ProfilePhotoCollectionPage page = new ProfilePhotoCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

