/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.RoleDefinition;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IRoleDefinitionWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class RoleDefinitionWithReferenceRequest
extends BaseRequest
implements IRoleDefinitionWithReferenceRequest {
    public RoleDefinitionWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RoleDefinition.class);
    }

    @Override
    public void post(RoleDefinition newRoleDefinition, IJsonBackedObject payload, ICallback<? super RoleDefinition> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public RoleDefinition post(RoleDefinition newRoleDefinition, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newRoleDefinition;
        }
        return null;
    }

    @Override
    public void get(ICallback<? super RoleDefinition> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public RoleDefinition get() throws ClientException {
        return (RoleDefinition)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super RoleDefinition> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(RoleDefinition sourceRoleDefinition, ICallback<? super RoleDefinition> callback) {
        this.send(HttpMethod.PATCH, callback, sourceRoleDefinition);
    }

    @Override
    public RoleDefinition patch(RoleDefinition sourceRoleDefinition) throws ClientException {
        return (RoleDefinition)this.send(HttpMethod.PATCH, sourceRoleDefinition);
    }

    @Override
    public IRoleDefinitionWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IRoleDefinitionWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

