/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamGetAllMessagesCollectionPage;
import com.microsoft.graph.requests.extensions.ITeamGetAllMessagesCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamGetAllMessagesCollectionPage;
import com.microsoft.graph.requests.extensions.TeamGetAllMessagesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamGetAllMessagesCollectionResponse;
import java.util.List;

public class TeamGetAllMessagesCollectionRequest
extends BaseCollectionRequest<TeamGetAllMessagesCollectionResponse, ITeamGetAllMessagesCollectionPage>
implements ITeamGetAllMessagesCollectionRequest {
    public TeamGetAllMessagesCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamGetAllMessagesCollectionResponse.class, ITeamGetAllMessagesCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ITeamGetAllMessagesCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TeamGetAllMessagesCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamGetAllMessagesCollectionPage get() throws ClientException {
        TeamGetAllMessagesCollectionResponse response = (TeamGetAllMessagesCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public ITeamGetAllMessagesCollectionPage buildFromResponse(TeamGetAllMessagesCollectionResponse response) {
        TeamGetAllMessagesCollectionRequestBuilder builder = response.nextLink != null ? new TeamGetAllMessagesCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamGetAllMessagesCollectionPage page = new TeamGetAllMessagesCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public ITeamGetAllMessagesCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamGetAllMessagesCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITeamGetAllMessagesCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public ITeamGetAllMessagesCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public ITeamGetAllMessagesCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

