/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Todo;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITodoRequest;
import java.util.List;

public class TodoRequest
extends BaseRequest
implements ITodoRequest {
    public TodoRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Todo.class);
    }

    @Override
    public void get(ICallback<? super Todo> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Todo get() throws ClientException {
        return (Todo)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Todo> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Todo sourceTodo, ICallback<? super Todo> callback) {
        this.send(HttpMethod.PATCH, callback, sourceTodo);
    }

    @Override
    public Todo patch(Todo sourceTodo) throws ClientException {
        return (Todo)this.send(HttpMethod.PATCH, sourceTodo);
    }

    @Override
    public void post(Todo newTodo, ICallback<? super Todo> callback) {
        this.send(HttpMethod.POST, callback, newTodo);
    }

    @Override
    public Todo post(Todo newTodo) throws ClientException {
        return (Todo)this.send(HttpMethod.POST, newTodo);
    }

    @Override
    public void put(Todo newTodo, ICallback<? super Todo> callback) {
        this.send(HttpMethod.PUT, callback, newTodo);
    }

    @Override
    public Todo put(Todo newTodo) throws ClientException {
        return (Todo)this.send(HttpMethod.PUT, newTodo);
    }

    @Override
    public ITodoRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITodoRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

