/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.TodoTask;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITodoTaskRequest;
import java.util.List;

public class TodoTaskRequest
extends BaseRequest
implements ITodoTaskRequest {
    public TodoTaskRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TodoTask.class);
    }

    @Override
    public void get(ICallback<? super TodoTask> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public TodoTask get() throws ClientException {
        return (TodoTask)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super TodoTask> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(TodoTask sourceTodoTask, ICallback<? super TodoTask> callback) {
        this.send(HttpMethod.PATCH, callback, sourceTodoTask);
    }

    @Override
    public TodoTask patch(TodoTask sourceTodoTask) throws ClientException {
        return (TodoTask)this.send(HttpMethod.PATCH, sourceTodoTask);
    }

    @Override
    public void post(TodoTask newTodoTask, ICallback<? super TodoTask> callback) {
        this.send(HttpMethod.POST, callback, newTodoTask);
    }

    @Override
    public TodoTask post(TodoTask newTodoTask) throws ClientException {
        return (TodoTask)this.send(HttpMethod.POST, newTodoTask);
    }

    @Override
    public void put(TodoTask newTodoTask, ICallback<? super TodoTask> callback) {
        this.send(HttpMethod.PUT, callback, newTodoTask);
    }

    @Override
    public TodoTask put(TodoTask newTodoTask) throws ClientException {
        return (TodoTask)this.send(HttpMethod.PUT, newTodoTask);
    }

    @Override
    public ITodoTaskRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITodoTaskRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

