/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.DefaultSerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class CollectionPageSerializer {
    private static DefaultSerializer serializer;
    private static final Integer pageLength;
    private static final Integer collectionLength;
    private static final Integer responseLength;
    private static final String extensionsPath = "extensions.";

    private CollectionPageSerializer() {
    }

    public static <T1, T2 extends IRequestBuilder> JsonElement serialize(BaseCollectionPage<T1, T2> src, ILogger logger) {
        if (src == null) {
            return null;
        }
        JsonArray jsonArray = new JsonArray();
        List<T1> items = src.getCurrentPage();
        serializer = new DefaultSerializer(logger);
        for (T1 item : items) {
            String json = serializer.serializeObject(item);
            JsonElement element = JsonParser.parseString((String)json);
            if (element == null || !element.isJsonObject()) continue;
            JsonObject jsonObject = element.getAsJsonObject();
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    public static <T1, T2 extends IRequestBuilder> BaseCollectionPage<T1, T2> deserialize(JsonElement json, Type typeOfT, ILogger logger) throws JsonParseException {
        if (json == null || !json.isJsonArray()) {
            return null;
        }
        serializer = new DefaultSerializer(logger);
        JsonArray sourceArray = json.getAsJsonArray();
        ArrayList list = new ArrayList(sourceArray.size());
        String collectionPageClassCanonicalName = typeOfT.getTypeName();
        String baseEntityClassCanonicalName = collectionPageClassCanonicalName.substring(0, collectionPageClassCanonicalName.length() - pageLength - collectionLength).replace("requests", "models");
        try {
            Class<?> baseEntityClass = Class.forName(baseEntityClassCanonicalName);
            for (JsonElement sourceElement : sourceArray) {
                if (!sourceElement.isJsonObject()) continue;
                JsonObject sourceObject = sourceElement.getAsJsonObject();
                Class<?> entityClass = serializer.getDerivedClass(sourceObject, baseEntityClass);
                if (entityClass == null) {
                    entityClass = baseEntityClass;
                }
                Object targetObject = serializer.deserializeObject(sourceObject.toString(), entityClass);
                ((IJsonBackedObject)targetObject).setRawObject(serializer, sourceObject);
                list.add(targetObject);
            }
            String responseClassCanonicalName = collectionPageClassCanonicalName.substring(0, collectionPageClassCanonicalName.length() - pageLength) + "Response";
            Class<?> responseClass = Class.forName(responseClassCanonicalName);
            Object response = responseClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            responseClass.getField("value").set(response, list);
            Class<?> collectionPageClass = Class.forName(collectionPageClassCanonicalName);
            String responseBuilderInterfaceCanonicalName = responseClassCanonicalName.substring(0, responseClassCanonicalName.length() - responseLength).replace(extensionsPath, "extensions.I") + "RequestBuilder";
            Class<?> responseBuilderInterfaceClass = Class.forName(responseBuilderInterfaceCanonicalName);
            return (BaseCollectionPage)collectionPageClass.getConstructor(responseClass, responseBuilderInterfaceClass).newInstance(response, null);
        }
        catch (ClassNotFoundException ex) {
            logger.logError("Could not find class during deserialization", ex);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            logger.logError("Could not instanciate type during deserialization", ex);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            logger.logError("Unable to set field value during deserialization", ex);
        }
        return null;
    }

    static {
        pageLength = 4;
        collectionLength = 10;
        responseLength = 8;
    }
}

