// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.DateTimeTimeZone;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Event Snooze Reminder Parameter Set.
 */
public class EventSnoozeReminderParameterSet {
    /**
     * The new Reminder Time.
     * 
     */
    @SerializedName(value = "newReminderTime", alternate = {"NewReminderTime"})
    @Expose
	@Nullable
    public DateTimeTimeZone newReminderTime;


    /**
     * Instiaciates a new EventSnoozeReminderParameterSet
     */
    public EventSnoozeReminderParameterSet() {}
    /**
     * Instiaciates a new EventSnoozeReminderParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected EventSnoozeReminderParameterSet(@Nonnull final EventSnoozeReminderParameterSetBuilder builder) {
        this.newReminderTime = builder.newReminderTime;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static EventSnoozeReminderParameterSetBuilder newBuilder() {
        return new EventSnoozeReminderParameterSetBuilder();
    }
    /**
     * Fluent builder for the EventSnoozeReminderParameterSet
     */
    public static final class EventSnoozeReminderParameterSetBuilder {
        /**
         * The newReminderTime parameter value
         */
        @Nullable
        protected DateTimeTimeZone newReminderTime;
        /**
         * Sets the NewReminderTime
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public EventSnoozeReminderParameterSetBuilder withNewReminderTime(@Nullable final DateTimeTimeZone val) {
            this.newReminderTime = val;
            return this;
        }
        /**
         * Instanciates a new EventSnoozeReminderParameterSetBuilder
         */
        @Nullable
        protected EventSnoozeReminderParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public EventSnoozeReminderParameterSet build() {
            return new EventSnoozeReminderParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.newReminderTime != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("newReminderTime", newReminderTime));
        }
        return result;
    }
}
