// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ItemActionStat;
import com.microsoft.graph.models.IncompleteData;
import com.microsoft.graph.models.ItemActivity;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.ItemActivityCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Activity Stat.
 */
public class ItemActivityStat extends Entity implements IJsonBackedObject {


    /**
     * The Access.
     * Statistics about the access actions in this interval. Read-only.
     */
    @SerializedName(value = "access", alternate = {"Access"})
    @Expose
	@Nullable
    public ItemActionStat access;

    /**
     * The Create.
     * Statistics about the create actions in this interval. Read-only.
     */
    @SerializedName(value = "create", alternate = {"Create"})
    @Expose
	@Nullable
    public ItemActionStat create;

    /**
     * The Delete.
     * Statistics about the delete actions in this interval. Read-only.
     */
    @SerializedName(value = "delete", alternate = {"Delete"})
    @Expose
	@Nullable
    public ItemActionStat delete;

    /**
     * The Edit.
     * Statistics about the edit actions in this interval. Read-only.
     */
    @SerializedName(value = "edit", alternate = {"Edit"})
    @Expose
	@Nullable
    public ItemActionStat edit;

    /**
     * The End Date Time.
     * When the interval ends. Read-only.
     */
    @SerializedName(value = "endDateTime", alternate = {"EndDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime endDateTime;

    /**
     * The Incomplete Data.
     * Indicates that the statistics in this interval are based on incomplete data. Read-only.
     */
    @SerializedName(value = "incompleteData", alternate = {"IncompleteData"})
    @Expose
	@Nullable
    public IncompleteData incompleteData;

    /**
     * The Is Trending.
     * Indicates whether the item is 'trending.' Read-only.
     */
    @SerializedName(value = "isTrending", alternate = {"IsTrending"})
    @Expose
	@Nullable
    public Boolean isTrending;

    /**
     * The Move.
     * Statistics about the move actions in this interval. Read-only.
     */
    @SerializedName(value = "move", alternate = {"Move"})
    @Expose
	@Nullable
    public ItemActionStat move;

    /**
     * The Start Date Time.
     * When the interval starts. Read-only.
     */
    @SerializedName(value = "startDateTime", alternate = {"StartDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startDateTime;

    /**
     * The Activities.
     * Exposes the itemActivities represented in this itemActivityStat resource.
     */
    @SerializedName(value = "activities", alternate = {"Activities"})
    @Expose
	@Nullable
    public ItemActivityCollectionPage activities;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("activities")) {
            activities = serializer.deserializeObject(json.get("activities"), ItemActivityCollectionPage.class);
        }
    }
}
