// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.PasswordCredential;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Principal Add Password Parameter Set.
 */
public class ServicePrincipalAddPasswordParameterSet {
    /**
     * The password Credential.
     * 
     */
    @SerializedName(value = "passwordCredential", alternate = {"PasswordCredential"})
    @Expose
	@Nullable
    public PasswordCredential passwordCredential;


    /**
     * Instiaciates a new ServicePrincipalAddPasswordParameterSet
     */
    public ServicePrincipalAddPasswordParameterSet() {}
    /**
     * Instiaciates a new ServicePrincipalAddPasswordParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ServicePrincipalAddPasswordParameterSet(@Nonnull final ServicePrincipalAddPasswordParameterSetBuilder builder) {
        this.passwordCredential = builder.passwordCredential;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ServicePrincipalAddPasswordParameterSetBuilder newBuilder() {
        return new ServicePrincipalAddPasswordParameterSetBuilder();
    }
    /**
     * Fluent builder for the ServicePrincipalAddPasswordParameterSet
     */
    public static final class ServicePrincipalAddPasswordParameterSetBuilder {
        /**
         * The passwordCredential parameter value
         */
        @Nullable
        protected PasswordCredential passwordCredential;
        /**
         * Sets the PasswordCredential
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ServicePrincipalAddPasswordParameterSetBuilder withPasswordCredential(@Nullable final PasswordCredential val) {
            this.passwordCredential = val;
            return this;
        }
        /**
         * Instanciates a new ServicePrincipalAddPasswordParameterSetBuilder
         */
        @Nullable
        protected ServicePrincipalAddPasswordParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ServicePrincipalAddPasswordParameterSet build() {
            return new ServicePrincipalAddPasswordParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.passwordCredential != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("passwordCredential", passwordCredential));
        }
        return result;
    }
}
