// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.TeamsApp;
import com.microsoft.graph.models.TeamsAppDefinition;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams App Installation.
 */
public class TeamsAppInstallation extends Entity implements IJsonBackedObject {


    /**
     * The Teams App.
     * The app that is installed.
     */
    @SerializedName(value = "teamsApp", alternate = {"TeamsApp"})
    @Expose
	@Nullable
    public TeamsApp teamsApp;

    /**
     * The Teams App Definition.
     * The details of this version of the app.
     */
    @SerializedName(value = "teamsAppDefinition", alternate = {"TeamsAppDefinition"})
    @Expose
	@Nullable
    public TeamsAppDefinition teamsAppDefinition;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
