// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Win32LobAppRegistryRuleOperationType;
import com.microsoft.graph.models.Win32LobAppRuleOperator;
import com.microsoft.graph.models.Win32LobAppRule;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Win32Lob App Registry Rule.
 */
public class Win32LobAppRegistryRule extends Win32LobAppRule implements IJsonBackedObject {


    /**
     * The Check32Bit On64System.
     * A value indicating whether to search the 32-bit registry on 64-bit systems.
     */
    @SerializedName(value = "check32BitOn64System", alternate = {"Check32BitOn64System"})
    @Expose
	@Nullable
    public Boolean check32BitOn64System;

    /**
     * The Comparison Value.
     * The registry comparison value.
     */
    @SerializedName(value = "comparisonValue", alternate = {"ComparisonValue"})
    @Expose
	@Nullable
    public String comparisonValue;

    /**
     * The Key Path.
     * The full path of the registry entry containing the value to detect.
     */
    @SerializedName(value = "keyPath", alternate = {"KeyPath"})
    @Expose
	@Nullable
    public String keyPath;

    /**
     * The Operation Type.
     * The registry operation type. Possible values are: notConfigured, exists, doesNotExist, string, integer, version.
     */
    @SerializedName(value = "operationType", alternate = {"OperationType"})
    @Expose
	@Nullable
    public Win32LobAppRegistryRuleOperationType operationType;

    /**
     * The Operator.
     * The operator for registry detection. Possible values are: notConfigured, equal, notEqual, greaterThan, greaterThanOrEqual, lessThan, lessThanOrEqual.
     */
    @SerializedName(value = "operator", alternate = {"Operator"})
    @Expose
	@Nullable
    public Win32LobAppRuleOperator operator;

    /**
     * The Value Name.
     * The name of the registry value to detect.
     */
    @SerializedName(value = "valueName", alternate = {"ValueName"})
    @Expose
	@Nullable
    public String valueName;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
