// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Days360Parameter Set.
 */
public class WorkbookFunctionsDays360ParameterSet {
    /**
     * The start Date.
     * 
     */
    @SerializedName(value = "startDate", alternate = {"StartDate"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement startDate;

    /**
     * The end Date.
     * 
     */
    @SerializedName(value = "endDate", alternate = {"EndDate"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement endDate;

    /**
     * The method.
     * 
     */
    @SerializedName(value = "method", alternate = {"Method"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement method;


    /**
     * Instiaciates a new WorkbookFunctionsDays360ParameterSet
     */
    public WorkbookFunctionsDays360ParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsDays360ParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsDays360ParameterSet(@Nonnull final WorkbookFunctionsDays360ParameterSetBuilder builder) {
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.method = builder.method;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsDays360ParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsDays360ParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsDays360ParameterSet
     */
    public static final class WorkbookFunctionsDays360ParameterSetBuilder {
        /**
         * The startDate parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement startDate;
        /**
         * Sets the StartDate
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsDays360ParameterSetBuilder withStartDate(@Nullable final com.google.gson.JsonElement val) {
            this.startDate = val;
            return this;
        }
        /**
         * The endDate parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement endDate;
        /**
         * Sets the EndDate
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsDays360ParameterSetBuilder withEndDate(@Nullable final com.google.gson.JsonElement val) {
            this.endDate = val;
            return this;
        }
        /**
         * The method parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement method;
        /**
         * Sets the Method
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsDays360ParameterSetBuilder withMethod(@Nullable final com.google.gson.JsonElement val) {
            this.method = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsDays360ParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsDays360ParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsDays360ParameterSet build() {
            return new WorkbookFunctionsDays360ParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.startDate != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("startDate", startDate));
        }
        if(this.endDate != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("endDate", endDate));
        }
        if(this.method != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("method", method));
        }
        return result;
    }
}
