// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessReviewScheduleDefinition;
import com.microsoft.graph.models.AccessReviewScheduleDefinitionFilterByCurrentUserOptions;
import com.microsoft.graph.requests.AccessReviewInstanceCollectionRequestBuilder;
import com.microsoft.graph.requests.AccessReviewInstanceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review Schedule Definition Request.
 */
public class AccessReviewScheduleDefinitionRequest extends BaseRequest<AccessReviewScheduleDefinition> {
	
    /**
     * The request for the AccessReviewScheduleDefinition
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessReviewScheduleDefinitionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessReviewScheduleDefinition.class);
    }

    /**
     * Gets the AccessReviewScheduleDefinition from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewScheduleDefinition> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessReviewScheduleDefinition from the service
     *
     * @return the AccessReviewScheduleDefinition from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewScheduleDefinition get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewScheduleDefinition> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessReviewScheduleDefinition delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessReviewScheduleDefinition with a source
     *
     * @param sourceAccessReviewScheduleDefinition the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewScheduleDefinition> patchAsync(@Nonnull final AccessReviewScheduleDefinition sourceAccessReviewScheduleDefinition) {
        return sendAsync(HttpMethod.PATCH, sourceAccessReviewScheduleDefinition);
    }

    /**
     * Patches this AccessReviewScheduleDefinition with a source
     *
     * @param sourceAccessReviewScheduleDefinition the source object with updates
     * @return the updated AccessReviewScheduleDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewScheduleDefinition patch(@Nonnull final AccessReviewScheduleDefinition sourceAccessReviewScheduleDefinition) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessReviewScheduleDefinition);
    }

    /**
     * Creates a AccessReviewScheduleDefinition with a new object
     *
     * @param newAccessReviewScheduleDefinition the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewScheduleDefinition> postAsync(@Nonnull final AccessReviewScheduleDefinition newAccessReviewScheduleDefinition) {
        return sendAsync(HttpMethod.POST, newAccessReviewScheduleDefinition);
    }

    /**
     * Creates a AccessReviewScheduleDefinition with a new object
     *
     * @param newAccessReviewScheduleDefinition the new object to create
     * @return the created AccessReviewScheduleDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewScheduleDefinition post(@Nonnull final AccessReviewScheduleDefinition newAccessReviewScheduleDefinition) throws ClientException {
        return send(HttpMethod.POST, newAccessReviewScheduleDefinition);
    }

    /**
     * Creates a AccessReviewScheduleDefinition with a new object
     *
     * @param newAccessReviewScheduleDefinition the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewScheduleDefinition> putAsync(@Nonnull final AccessReviewScheduleDefinition newAccessReviewScheduleDefinition) {
        return sendAsync(HttpMethod.PUT, newAccessReviewScheduleDefinition);
    }

    /**
     * Creates a AccessReviewScheduleDefinition with a new object
     *
     * @param newAccessReviewScheduleDefinition the object to create/update
     * @return the created AccessReviewScheduleDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewScheduleDefinition put(@Nonnull final AccessReviewScheduleDefinition newAccessReviewScheduleDefinition) throws ClientException {
        return send(HttpMethod.PUT, newAccessReviewScheduleDefinition);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessReviewScheduleDefinitionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessReviewScheduleDefinitionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

