// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EBookInstallSummary;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the EBook Install Summary Request.
 */
public class EBookInstallSummaryRequest extends BaseRequest<EBookInstallSummary> {
	
    /**
     * The request for the EBookInstallSummary
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EBookInstallSummaryRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EBookInstallSummary.class);
    }

    /**
     * Gets the EBookInstallSummary from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EBookInstallSummary> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EBookInstallSummary from the service
     *
     * @return the EBookInstallSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EBookInstallSummary get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EBookInstallSummary> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EBookInstallSummary delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EBookInstallSummary with a source
     *
     * @param sourceEBookInstallSummary the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EBookInstallSummary> patchAsync(@Nonnull final EBookInstallSummary sourceEBookInstallSummary) {
        return sendAsync(HttpMethod.PATCH, sourceEBookInstallSummary);
    }

    /**
     * Patches this EBookInstallSummary with a source
     *
     * @param sourceEBookInstallSummary the source object with updates
     * @return the updated EBookInstallSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EBookInstallSummary patch(@Nonnull final EBookInstallSummary sourceEBookInstallSummary) throws ClientException {
        return send(HttpMethod.PATCH, sourceEBookInstallSummary);
    }

    /**
     * Creates a EBookInstallSummary with a new object
     *
     * @param newEBookInstallSummary the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EBookInstallSummary> postAsync(@Nonnull final EBookInstallSummary newEBookInstallSummary) {
        return sendAsync(HttpMethod.POST, newEBookInstallSummary);
    }

    /**
     * Creates a EBookInstallSummary with a new object
     *
     * @param newEBookInstallSummary the new object to create
     * @return the created EBookInstallSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EBookInstallSummary post(@Nonnull final EBookInstallSummary newEBookInstallSummary) throws ClientException {
        return send(HttpMethod.POST, newEBookInstallSummary);
    }

    /**
     * Creates a EBookInstallSummary with a new object
     *
     * @param newEBookInstallSummary the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EBookInstallSummary> putAsync(@Nonnull final EBookInstallSummary newEBookInstallSummary) {
        return sendAsync(HttpMethod.PUT, newEBookInstallSummary);
    }

    /**
     * Creates a EBookInstallSummary with a new object
     *
     * @param newEBookInstallSummary the object to create/update
     * @return the created EBookInstallSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EBookInstallSummary put(@Nonnull final EBookInstallSummary newEBookInstallSummary) throws ClientException {
        return send(HttpMethod.PUT, newEBookInstallSummary);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EBookInstallSummaryRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EBookInstallSummaryRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

