// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationClass;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.EducationClassDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.EducationClassDeltaCollectionRequest;
import com.microsoft.graph.requests.EducationClassDeltaCollectionResponse;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Class Delta Collection Request Builder.
 */
public class EducationClassDeltaCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<EducationClass, EducationClassDeltaCollectionRequestBuilder, EducationClassDeltaCollectionResponse, EducationClassDeltaCollectionPage, EducationClassDeltaCollectionRequest> {

    /**
     * The request builder for this collection of EducationClass
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationClassDeltaCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationClassDeltaCollectionRequestBuilder.class, EducationClassDeltaCollectionRequest.class);
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the EducationClassDeltaCollectionRequest instance
     */
    @Override
    @Nonnull
    public EducationClassDeltaCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final EducationClassDeltaCollectionRequest request = super.buildRequest(requestOptions);
        return request;
    }
}
