// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IdentityBuiltInUserFlowAttribute;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Built In User Flow Attribute Request.
 */
public class IdentityBuiltInUserFlowAttributeRequest extends BaseRequest<IdentityBuiltInUserFlowAttribute> {
	
    /**
     * The request for the IdentityBuiltInUserFlowAttribute
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityBuiltInUserFlowAttributeRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityBuiltInUserFlowAttribute.class);
    }

    /**
     * Gets the IdentityBuiltInUserFlowAttribute from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityBuiltInUserFlowAttribute> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IdentityBuiltInUserFlowAttribute from the service
     *
     * @return the IdentityBuiltInUserFlowAttribute from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityBuiltInUserFlowAttribute get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityBuiltInUserFlowAttribute> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IdentityBuiltInUserFlowAttribute delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IdentityBuiltInUserFlowAttribute with a source
     *
     * @param sourceIdentityBuiltInUserFlowAttribute the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityBuiltInUserFlowAttribute> patchAsync(@Nonnull final IdentityBuiltInUserFlowAttribute sourceIdentityBuiltInUserFlowAttribute) {
        return sendAsync(HttpMethod.PATCH, sourceIdentityBuiltInUserFlowAttribute);
    }

    /**
     * Patches this IdentityBuiltInUserFlowAttribute with a source
     *
     * @param sourceIdentityBuiltInUserFlowAttribute the source object with updates
     * @return the updated IdentityBuiltInUserFlowAttribute
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityBuiltInUserFlowAttribute patch(@Nonnull final IdentityBuiltInUserFlowAttribute sourceIdentityBuiltInUserFlowAttribute) throws ClientException {
        return send(HttpMethod.PATCH, sourceIdentityBuiltInUserFlowAttribute);
    }

    /**
     * Creates a IdentityBuiltInUserFlowAttribute with a new object
     *
     * @param newIdentityBuiltInUserFlowAttribute the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityBuiltInUserFlowAttribute> postAsync(@Nonnull final IdentityBuiltInUserFlowAttribute newIdentityBuiltInUserFlowAttribute) {
        return sendAsync(HttpMethod.POST, newIdentityBuiltInUserFlowAttribute);
    }

    /**
     * Creates a IdentityBuiltInUserFlowAttribute with a new object
     *
     * @param newIdentityBuiltInUserFlowAttribute the new object to create
     * @return the created IdentityBuiltInUserFlowAttribute
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityBuiltInUserFlowAttribute post(@Nonnull final IdentityBuiltInUserFlowAttribute newIdentityBuiltInUserFlowAttribute) throws ClientException {
        return send(HttpMethod.POST, newIdentityBuiltInUserFlowAttribute);
    }

    /**
     * Creates a IdentityBuiltInUserFlowAttribute with a new object
     *
     * @param newIdentityBuiltInUserFlowAttribute the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityBuiltInUserFlowAttribute> putAsync(@Nonnull final IdentityBuiltInUserFlowAttribute newIdentityBuiltInUserFlowAttribute) {
        return sendAsync(HttpMethod.PUT, newIdentityBuiltInUserFlowAttribute);
    }

    /**
     * Creates a IdentityBuiltInUserFlowAttribute with a new object
     *
     * @param newIdentityBuiltInUserFlowAttribute the object to create/update
     * @return the created IdentityBuiltInUserFlowAttribute
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityBuiltInUserFlowAttribute put(@Nonnull final IdentityBuiltInUserFlowAttribute newIdentityBuiltInUserFlowAttribute) throws ClientException {
        return send(HttpMethod.PUT, newIdentityBuiltInUserFlowAttribute);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IdentityBuiltInUserFlowAttributeRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IdentityBuiltInUserFlowAttributeRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

