// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeletedWindowsAutopilotDeviceState;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequestBuilder;
import com.microsoft.graph.requests.WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequest;
import com.microsoft.graph.requests.WindowsAutopilotDeviceIdentityDeleteDevicesCollectionResponse;
import com.microsoft.graph.models.WindowsAutopilotDeviceIdentityDeleteDevicesParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseActionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Autopilot Device Identity Delete Devices Collection Request Builder.
 */
public class WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequestBuilder extends BaseActionCollectionRequestBuilder<DeletedWindowsAutopilotDeviceState, WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequestBuilder, WindowsAutopilotDeviceIdentityDeleteDevicesCollectionResponse, WindowsAutopilotDeviceIdentityDeleteDevicesCollectionPage, WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequest> {

    /**
     * The request builder for this collection of WindowsAutopilotDeviceIdentity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequestBuilder.class, WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequest.class);
    }
    private WindowsAutopilotDeviceIdentityDeleteDevicesParameterSet body;
    /**
     * The request builder for this collection of WindowsAutopilotDeviceIdentity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final WindowsAutopilotDeviceIdentityDeleteDevicesParameterSet parameters) {
        super(requestUrl, client, requestOptions, WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequestBuilder.class, WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequest.class);
        this.body = parameters;
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequest instance
     */
    @Override
    @Nonnull
    public WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final WindowsAutopilotDeviceIdentityDeleteDevicesCollectionRequest request = super.buildRequest(requestOptions);
            request.body = this.body;
            return request;
    }
}
