/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.identitygovernance.models.TaskDefinition;
import com.microsoft.graph.identitygovernance.requests.TaskDefinitionCollectionPage;
import com.microsoft.graph.identitygovernance.requests.TaskDefinitionCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.TaskDefinitionCollectionResponse;
import com.microsoft.graph.identitygovernance.requests.TaskDefinitionRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TaskDefinitionCollectionRequest
extends BaseEntityCollectionRequest<TaskDefinition, TaskDefinitionCollectionResponse, TaskDefinitionCollectionPage> {
    public TaskDefinitionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TaskDefinitionCollectionResponse.class, TaskDefinitionCollectionPage.class, TaskDefinitionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<TaskDefinition> postAsync(@Nonnull TaskDefinition newTaskDefinition) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TaskDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newTaskDefinition);
    }

    @Nonnull
    public TaskDefinition post(@Nonnull TaskDefinition newTaskDefinition) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TaskDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTaskDefinition);
    }

    @Nonnull
    public TaskDefinitionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public TaskDefinitionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public TaskDefinitionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public TaskDefinitionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public TaskDefinitionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public TaskDefinitionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public TaskDefinitionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public TaskDefinitionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public TaskDefinitionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

