/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AccessPackage;
import com.microsoft.graph.models.AccessPackageCatalogState;
import com.microsoft.graph.models.AccessPackageCatalogType;
import com.microsoft.graph.models.AccessPackageResource;
import com.microsoft.graph.models.AccessPackageResourceRole;
import com.microsoft.graph.models.AccessPackageResourceScope;
import com.microsoft.graph.models.CustomCalloutExtension;
import com.microsoft.graph.models.Entity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AccessPackageCatalog
extends Entity
implements Parsable {
    @Nonnull
    public static AccessPackageCatalog createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AccessPackageCatalog();
    }

    @Nullable
    public List<AccessPackage> getAccessPackages() {
        return (List)this.backingStore.get("accessPackages");
    }

    @Nullable
    public AccessPackageCatalogType getCatalogType() {
        return (AccessPackageCatalogType)((Object)this.backingStore.get("catalogType"));
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public List<CustomCalloutExtension> getCustomWorkflowExtensions() {
        return (List)this.backingStore.get("customWorkflowExtensions");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("accessPackages", n -> this.setAccessPackages(n.getCollectionOfObjectValues(AccessPackage::createFromDiscriminatorValue)));
        deserializerMap.put("catalogType", n -> this.setCatalogType((AccessPackageCatalogType)n.getEnumValue(AccessPackageCatalogType::forValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("customWorkflowExtensions", n -> this.setCustomWorkflowExtensions(n.getCollectionOfObjectValues(CustomCalloutExtension::createFromDiscriminatorValue)));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("isExternallyVisible", n -> this.setIsExternallyVisible(n.getBooleanValue()));
        deserializerMap.put("modifiedDateTime", n -> this.setModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("resourceRoles", n -> this.setResourceRoles(n.getCollectionOfObjectValues(AccessPackageResourceRole::createFromDiscriminatorValue)));
        deserializerMap.put("resources", n -> this.setResources(n.getCollectionOfObjectValues(AccessPackageResource::createFromDiscriminatorValue)));
        deserializerMap.put("resourceScopes", n -> this.setResourceScopes(n.getCollectionOfObjectValues(AccessPackageResourceScope::createFromDiscriminatorValue)));
        deserializerMap.put("state", n -> this.setState((AccessPackageCatalogState)n.getEnumValue(AccessPackageCatalogState::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsExternallyVisible() {
        return (Boolean)this.backingStore.get("isExternallyVisible");
    }

    @Nullable
    public OffsetDateTime getModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("modifiedDateTime");
    }

    @Nullable
    public List<AccessPackageResourceRole> getResourceRoles() {
        return (List)this.backingStore.get("resourceRoles");
    }

    @Nullable
    public List<AccessPackageResource> getResources() {
        return (List)this.backingStore.get("resources");
    }

    @Nullable
    public List<AccessPackageResourceScope> getResourceScopes() {
        return (List)this.backingStore.get("resourceScopes");
    }

    @Nullable
    public AccessPackageCatalogState getState() {
        return (AccessPackageCatalogState)((Object)this.backingStore.get("state"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("accessPackages", this.getAccessPackages());
        writer.writeEnumValue("catalogType", (Enum)this.getCatalogType());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeCollectionOfObjectValues("customWorkflowExtensions", this.getCustomWorkflowExtensions());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeBooleanValue("isExternallyVisible", this.getIsExternallyVisible());
        writer.writeOffsetDateTimeValue("modifiedDateTime", this.getModifiedDateTime());
        writer.writeCollectionOfObjectValues("resourceRoles", this.getResourceRoles());
        writer.writeCollectionOfObjectValues("resources", this.getResources());
        writer.writeCollectionOfObjectValues("resourceScopes", this.getResourceScopes());
        writer.writeEnumValue("state", (Enum)this.getState());
    }

    public void setAccessPackages(@Nullable List<AccessPackage> value) {
        this.backingStore.set("accessPackages", value);
    }

    public void setCatalogType(@Nullable AccessPackageCatalogType value) {
        this.backingStore.set("catalogType", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCustomWorkflowExtensions(@Nullable List<CustomCalloutExtension> value) {
        this.backingStore.set("customWorkflowExtensions", value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setIsExternallyVisible(@Nullable Boolean value) {
        this.backingStore.set("isExternallyVisible", (Object)value);
    }

    public void setModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("modifiedDateTime", (Object)value);
    }

    public void setResourceRoles(@Nullable List<AccessPackageResourceRole> value) {
        this.backingStore.set("resourceRoles", value);
    }

    public void setResources(@Nullable List<AccessPackageResource> value) {
        this.backingStore.set("resources", value);
    }

    public void setResourceScopes(@Nullable List<AccessPackageResourceScope> value) {
        this.backingStore.set("resourceScopes", value);
    }

    public void setState(@Nullable AccessPackageCatalogState value) {
        this.backingStore.set("state", (Object)value);
    }
}

