/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BrowserSharedCookie;
import com.microsoft.graph.models.BrowserSite;
import com.microsoft.graph.models.BrowserSiteListStatus;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BrowserSiteList
extends Entity
implements Parsable {
    @Nonnull
    public static BrowserSiteList createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new BrowserSiteList();
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("publishedBy", n -> this.setPublishedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("publishedDateTime", n -> this.setPublishedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("revision", n -> this.setRevision(n.getStringValue()));
        deserializerMap.put("sharedCookies", n -> this.setSharedCookies(n.getCollectionOfObjectValues(BrowserSharedCookie::createFromDiscriminatorValue)));
        deserializerMap.put("sites", n -> this.setSites(n.getCollectionOfObjectValues(BrowserSite::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((BrowserSiteListStatus)n.getEnumValue(BrowserSiteListStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getLastModifiedBy() {
        return (IdentitySet)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public IdentitySet getPublishedBy() {
        return (IdentitySet)this.backingStore.get("publishedBy");
    }

    @Nullable
    public OffsetDateTime getPublishedDateTime() {
        return (OffsetDateTime)this.backingStore.get("publishedDateTime");
    }

    @Nullable
    public String getRevision() {
        return (String)this.backingStore.get("revision");
    }

    @Nullable
    public List<BrowserSharedCookie> getSharedCookies() {
        return (List)this.backingStore.get("sharedCookies");
    }

    @Nullable
    public List<BrowserSite> getSites() {
        return (List)this.backingStore.get("sites");
    }

    @Nullable
    public BrowserSiteListStatus getStatus() {
        return (BrowserSiteListStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("lastModifiedBy", (Parsable)this.getLastModifiedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeObjectValue("publishedBy", (Parsable)this.getPublishedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("publishedDateTime", this.getPublishedDateTime());
        writer.writeStringValue("revision", this.getRevision());
        writer.writeCollectionOfObjectValues("sharedCookies", this.getSharedCookies());
        writer.writeCollectionOfObjectValues("sites", this.getSites());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLastModifiedBy(@Nullable IdentitySet value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setPublishedBy(@Nullable IdentitySet value) {
        this.backingStore.set("publishedBy", (Object)value);
    }

    public void setPublishedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("publishedDateTime", (Object)value);
    }

    public void setRevision(@Nullable String value) {
        this.backingStore.set("revision", (Object)value);
    }

    public void setSharedCookies(@Nullable List<BrowserSharedCookie> value) {
        this.backingStore.set("sharedCookies", value);
    }

    public void setSites(@Nullable List<BrowserSite> value) {
        this.backingStore.set("sites", value);
    }

    public void setStatus(@Nullable BrowserSiteListStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

