/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.Location;
import com.microsoft.graph.models.PersonType;
import com.microsoft.graph.models.Phone;
import com.microsoft.graph.models.ScoredEmailAddress;
import com.microsoft.graph.models.Website;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Person
extends Entity
implements Parsable {
    @Nonnull
    public static Person createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Person();
    }

    @Nullable
    public String getBirthday() {
        return (String)this.backingStore.get("birthday");
    }

    @Nullable
    public String getCompanyName() {
        return (String)this.backingStore.get("companyName");
    }

    @Nullable
    public String getDepartment() {
        return (String)this.backingStore.get("department");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("birthday", n -> this.setBirthday(n.getStringValue()));
        deserializerMap.put("companyName", n -> this.setCompanyName(n.getStringValue()));
        deserializerMap.put("department", n -> this.setDepartment(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("givenName", n -> this.setGivenName(n.getStringValue()));
        deserializerMap.put("imAddress", n -> this.setImAddress(n.getStringValue()));
        deserializerMap.put("isFavorite", n -> this.setIsFavorite(n.getBooleanValue()));
        deserializerMap.put("jobTitle", n -> this.setJobTitle(n.getStringValue()));
        deserializerMap.put("officeLocation", n -> this.setOfficeLocation(n.getStringValue()));
        deserializerMap.put("personNotes", n -> this.setPersonNotes(n.getStringValue()));
        deserializerMap.put("personType", n -> this.setPersonType((PersonType)n.getObjectValue(PersonType::createFromDiscriminatorValue)));
        deserializerMap.put("phones", n -> this.setPhones(n.getCollectionOfObjectValues(Phone::createFromDiscriminatorValue)));
        deserializerMap.put("postalAddresses", n -> this.setPostalAddresses(n.getCollectionOfObjectValues(Location::createFromDiscriminatorValue)));
        deserializerMap.put("profession", n -> this.setProfession(n.getStringValue()));
        deserializerMap.put("scoredEmailAddresses", n -> this.setScoredEmailAddresses(n.getCollectionOfObjectValues(ScoredEmailAddress::createFromDiscriminatorValue)));
        deserializerMap.put("surname", n -> this.setSurname(n.getStringValue()));
        deserializerMap.put("userPrincipalName", n -> this.setUserPrincipalName(n.getStringValue()));
        deserializerMap.put("websites", n -> this.setWebsites(n.getCollectionOfObjectValues(Website::createFromDiscriminatorValue)));
        deserializerMap.put("yomiCompany", n -> this.setYomiCompany(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getGivenName() {
        return (String)this.backingStore.get("givenName");
    }

    @Nullable
    public String getImAddress() {
        return (String)this.backingStore.get("imAddress");
    }

    @Nullable
    public Boolean getIsFavorite() {
        return (Boolean)this.backingStore.get("isFavorite");
    }

    @Nullable
    public String getJobTitle() {
        return (String)this.backingStore.get("jobTitle");
    }

    @Nullable
    public String getOfficeLocation() {
        return (String)this.backingStore.get("officeLocation");
    }

    @Nullable
    public String getPersonNotes() {
        return (String)this.backingStore.get("personNotes");
    }

    @Nullable
    public PersonType getPersonType() {
        return (PersonType)this.backingStore.get("personType");
    }

    @Nullable
    public List<Phone> getPhones() {
        return (List)this.backingStore.get("phones");
    }

    @Nullable
    public List<Location> getPostalAddresses() {
        return (List)this.backingStore.get("postalAddresses");
    }

    @Nullable
    public String getProfession() {
        return (String)this.backingStore.get("profession");
    }

    @Nullable
    public List<ScoredEmailAddress> getScoredEmailAddresses() {
        return (List)this.backingStore.get("scoredEmailAddresses");
    }

    @Nullable
    public String getSurname() {
        return (String)this.backingStore.get("surname");
    }

    @Nullable
    public String getUserPrincipalName() {
        return (String)this.backingStore.get("userPrincipalName");
    }

    @Nullable
    public List<Website> getWebsites() {
        return (List)this.backingStore.get("websites");
    }

    @Nullable
    public String getYomiCompany() {
        return (String)this.backingStore.get("yomiCompany");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("birthday", this.getBirthday());
        writer.writeStringValue("companyName", this.getCompanyName());
        writer.writeStringValue("department", this.getDepartment());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("givenName", this.getGivenName());
        writer.writeStringValue("imAddress", this.getImAddress());
        writer.writeBooleanValue("isFavorite", this.getIsFavorite());
        writer.writeStringValue("jobTitle", this.getJobTitle());
        writer.writeStringValue("officeLocation", this.getOfficeLocation());
        writer.writeStringValue("personNotes", this.getPersonNotes());
        writer.writeObjectValue("personType", (Parsable)this.getPersonType(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("phones", this.getPhones());
        writer.writeCollectionOfObjectValues("postalAddresses", this.getPostalAddresses());
        writer.writeStringValue("profession", this.getProfession());
        writer.writeCollectionOfObjectValues("scoredEmailAddresses", this.getScoredEmailAddresses());
        writer.writeStringValue("surname", this.getSurname());
        writer.writeStringValue("userPrincipalName", this.getUserPrincipalName());
        writer.writeCollectionOfObjectValues("websites", this.getWebsites());
        writer.writeStringValue("yomiCompany", this.getYomiCompany());
    }

    public void setBirthday(@Nullable String value) {
        this.backingStore.set("birthday", (Object)value);
    }

    public void setCompanyName(@Nullable String value) {
        this.backingStore.set("companyName", (Object)value);
    }

    public void setDepartment(@Nullable String value) {
        this.backingStore.set("department", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setGivenName(@Nullable String value) {
        this.backingStore.set("givenName", (Object)value);
    }

    public void setImAddress(@Nullable String value) {
        this.backingStore.set("imAddress", (Object)value);
    }

    public void setIsFavorite(@Nullable Boolean value) {
        this.backingStore.set("isFavorite", (Object)value);
    }

    public void setJobTitle(@Nullable String value) {
        this.backingStore.set("jobTitle", (Object)value);
    }

    public void setOfficeLocation(@Nullable String value) {
        this.backingStore.set("officeLocation", (Object)value);
    }

    public void setPersonNotes(@Nullable String value) {
        this.backingStore.set("personNotes", (Object)value);
    }

    public void setPersonType(@Nullable PersonType value) {
        this.backingStore.set("personType", (Object)value);
    }

    public void setPhones(@Nullable List<Phone> value) {
        this.backingStore.set("phones", value);
    }

    public void setPostalAddresses(@Nullable List<Location> value) {
        this.backingStore.set("postalAddresses", value);
    }

    public void setProfession(@Nullable String value) {
        this.backingStore.set("profession", (Object)value);
    }

    public void setScoredEmailAddresses(@Nullable List<ScoredEmailAddress> value) {
        this.backingStore.set("scoredEmailAddresses", value);
    }

    public void setSurname(@Nullable String value) {
        this.backingStore.set("surname", (Object)value);
    }

    public void setUserPrincipalName(@Nullable String value) {
        this.backingStore.set("userPrincipalName", (Object)value);
    }

    public void setWebsites(@Nullable List<Website> value) {
        this.backingStore.set("websites", value);
    }

    public void setYomiCompany(@Nullable String value) {
        this.backingStore.set("yomiCompany", (Object)value);
    }
}

