/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.PrintUsageByPrinter;
import com.microsoft.graph.models.PrintUsageByUser;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PrintUsage
extends Entity
implements Parsable {
    @Nonnull
    public static PrintUsage createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.printUsageByPrinter": {
                    return new PrintUsageByPrinter();
                }
                case "#microsoft.graph.printUsageByUser": {
                    return new PrintUsageByUser();
                }
            }
        }
        return new PrintUsage();
    }

    @Nullable
    public Long getBlackAndWhitePageCount() {
        return (Long)this.backingStore.get("blackAndWhitePageCount");
    }

    @Nullable
    public Long getColorPageCount() {
        return (Long)this.backingStore.get("colorPageCount");
    }

    @Nullable
    public Long getCompletedBlackAndWhiteJobCount() {
        return (Long)this.backingStore.get("completedBlackAndWhiteJobCount");
    }

    @Nullable
    public Long getCompletedColorJobCount() {
        return (Long)this.backingStore.get("completedColorJobCount");
    }

    @Nullable
    public Long getCompletedJobCount() {
        return (Long)this.backingStore.get("completedJobCount");
    }

    @Nullable
    public Long getDoubleSidedSheetCount() {
        return (Long)this.backingStore.get("doubleSidedSheetCount");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("blackAndWhitePageCount", n -> this.setBlackAndWhitePageCount(n.getLongValue()));
        deserializerMap.put("colorPageCount", n -> this.setColorPageCount(n.getLongValue()));
        deserializerMap.put("completedBlackAndWhiteJobCount", n -> this.setCompletedBlackAndWhiteJobCount(n.getLongValue()));
        deserializerMap.put("completedColorJobCount", n -> this.setCompletedColorJobCount(n.getLongValue()));
        deserializerMap.put("completedJobCount", n -> this.setCompletedJobCount(n.getLongValue()));
        deserializerMap.put("doubleSidedSheetCount", n -> this.setDoubleSidedSheetCount(n.getLongValue()));
        deserializerMap.put("incompleteJobCount", n -> this.setIncompleteJobCount(n.getLongValue()));
        deserializerMap.put("mediaSheetCount", n -> this.setMediaSheetCount(n.getLongValue()));
        deserializerMap.put("pageCount", n -> this.setPageCount(n.getLongValue()));
        deserializerMap.put("singleSidedSheetCount", n -> this.setSingleSidedSheetCount(n.getLongValue()));
        deserializerMap.put("usageDate", n -> this.setUsageDate(n.getLocalDateValue()));
        return deserializerMap;
    }

    @Nullable
    public Long getIncompleteJobCount() {
        return (Long)this.backingStore.get("incompleteJobCount");
    }

    @Nullable
    public Long getMediaSheetCount() {
        return (Long)this.backingStore.get("mediaSheetCount");
    }

    @Nullable
    public Long getPageCount() {
        return (Long)this.backingStore.get("pageCount");
    }

    @Nullable
    public Long getSingleSidedSheetCount() {
        return (Long)this.backingStore.get("singleSidedSheetCount");
    }

    @Nullable
    public LocalDate getUsageDate() {
        return (LocalDate)this.backingStore.get("usageDate");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeLongValue("blackAndWhitePageCount", this.getBlackAndWhitePageCount());
        writer.writeLongValue("colorPageCount", this.getColorPageCount());
        writer.writeLongValue("completedBlackAndWhiteJobCount", this.getCompletedBlackAndWhiteJobCount());
        writer.writeLongValue("completedColorJobCount", this.getCompletedColorJobCount());
        writer.writeLongValue("completedJobCount", this.getCompletedJobCount());
        writer.writeLongValue("doubleSidedSheetCount", this.getDoubleSidedSheetCount());
        writer.writeLongValue("incompleteJobCount", this.getIncompleteJobCount());
        writer.writeLongValue("mediaSheetCount", this.getMediaSheetCount());
        writer.writeLongValue("pageCount", this.getPageCount());
        writer.writeLongValue("singleSidedSheetCount", this.getSingleSidedSheetCount());
        writer.writeLocalDateValue("usageDate", this.getUsageDate());
    }

    public void setBlackAndWhitePageCount(@Nullable Long value) {
        this.backingStore.set("blackAndWhitePageCount", (Object)value);
    }

    public void setColorPageCount(@Nullable Long value) {
        this.backingStore.set("colorPageCount", (Object)value);
    }

    public void setCompletedBlackAndWhiteJobCount(@Nullable Long value) {
        this.backingStore.set("completedBlackAndWhiteJobCount", (Object)value);
    }

    public void setCompletedColorJobCount(@Nullable Long value) {
        this.backingStore.set("completedColorJobCount", (Object)value);
    }

    public void setCompletedJobCount(@Nullable Long value) {
        this.backingStore.set("completedJobCount", (Object)value);
    }

    public void setDoubleSidedSheetCount(@Nullable Long value) {
        this.backingStore.set("doubleSidedSheetCount", (Object)value);
    }

    public void setIncompleteJobCount(@Nullable Long value) {
        this.backingStore.set("incompleteJobCount", (Object)value);
    }

    public void setMediaSheetCount(@Nullable Long value) {
        this.backingStore.set("mediaSheetCount", (Object)value);
    }

    public void setPageCount(@Nullable Long value) {
        this.backingStore.set("pageCount", (Object)value);
    }

    public void setSingleSidedSheetCount(@Nullable Long value) {
        this.backingStore.set("singleSidedSheetCount", (Object)value);
    }

    public void setUsageDate(@Nullable LocalDate value) {
        this.backingStore.set("usageDate", (Object)value);
    }
}

