/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DeviceConfiguration;
import com.microsoft.graph.models.SharedPCAccountManagerPolicy;
import com.microsoft.graph.models.SharedPCAllowedAccountType;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SharedPCConfiguration
extends DeviceConfiguration
implements Parsable {
    public SharedPCConfiguration() {
        this.setOdataType("#microsoft.graph.sharedPCConfiguration");
    }

    @Nonnull
    public static SharedPCConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SharedPCConfiguration();
    }

    @Nullable
    public SharedPCAccountManagerPolicy getAccountManagerPolicy() {
        return (SharedPCAccountManagerPolicy)this.backingStore.get("accountManagerPolicy");
    }

    @Nullable
    public EnumSet<SharedPCAllowedAccountType> getAllowedAccounts() {
        return (EnumSet)this.backingStore.get("allowedAccounts");
    }

    @Nullable
    public Boolean getAllowLocalStorage() {
        return (Boolean)this.backingStore.get("allowLocalStorage");
    }

    @Nullable
    public Boolean getDisableAccountManager() {
        return (Boolean)this.backingStore.get("disableAccountManager");
    }

    @Nullable
    public Boolean getDisableEduPolicies() {
        return (Boolean)this.backingStore.get("disableEduPolicies");
    }

    @Nullable
    public Boolean getDisablePowerPolicies() {
        return (Boolean)this.backingStore.get("disablePowerPolicies");
    }

    @Nullable
    public Boolean getDisableSignInOnResume() {
        return (Boolean)this.backingStore.get("disableSignInOnResume");
    }

    @Nullable
    public Boolean getEnabled() {
        return (Boolean)this.backingStore.get("enabled");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("accountManagerPolicy", n -> this.setAccountManagerPolicy((SharedPCAccountManagerPolicy)n.getObjectValue(SharedPCAccountManagerPolicy::createFromDiscriminatorValue)));
        deserializerMap.put("allowedAccounts", n -> this.setAllowedAccounts(n.getEnumSetValue(SharedPCAllowedAccountType::forValue)));
        deserializerMap.put("allowLocalStorage", n -> this.setAllowLocalStorage(n.getBooleanValue()));
        deserializerMap.put("disableAccountManager", n -> this.setDisableAccountManager(n.getBooleanValue()));
        deserializerMap.put("disableEduPolicies", n -> this.setDisableEduPolicies(n.getBooleanValue()));
        deserializerMap.put("disablePowerPolicies", n -> this.setDisablePowerPolicies(n.getBooleanValue()));
        deserializerMap.put("disableSignInOnResume", n -> this.setDisableSignInOnResume(n.getBooleanValue()));
        deserializerMap.put("enabled", n -> this.setEnabled(n.getBooleanValue()));
        deserializerMap.put("idleTimeBeforeSleepInSeconds", n -> this.setIdleTimeBeforeSleepInSeconds(n.getIntegerValue()));
        deserializerMap.put("kioskAppDisplayName", n -> this.setKioskAppDisplayName(n.getStringValue()));
        deserializerMap.put("kioskAppUserModelId", n -> this.setKioskAppUserModelId(n.getStringValue()));
        deserializerMap.put("maintenanceStartTime", n -> this.setMaintenanceStartTime(n.getLocalTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public Integer getIdleTimeBeforeSleepInSeconds() {
        return (Integer)this.backingStore.get("idleTimeBeforeSleepInSeconds");
    }

    @Nullable
    public String getKioskAppDisplayName() {
        return (String)this.backingStore.get("kioskAppDisplayName");
    }

    @Nullable
    public String getKioskAppUserModelId() {
        return (String)this.backingStore.get("kioskAppUserModelId");
    }

    @Nullable
    public LocalTime getMaintenanceStartTime() {
        return (LocalTime)this.backingStore.get("maintenanceStartTime");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("accountManagerPolicy", (Parsable)this.getAccountManagerPolicy(), new Parsable[0]);
        writer.writeEnumSetValue("allowedAccounts", this.getAllowedAccounts());
        writer.writeBooleanValue("allowLocalStorage", this.getAllowLocalStorage());
        writer.writeBooleanValue("disableAccountManager", this.getDisableAccountManager());
        writer.writeBooleanValue("disableEduPolicies", this.getDisableEduPolicies());
        writer.writeBooleanValue("disablePowerPolicies", this.getDisablePowerPolicies());
        writer.writeBooleanValue("disableSignInOnResume", this.getDisableSignInOnResume());
        writer.writeBooleanValue("enabled", this.getEnabled());
        writer.writeIntegerValue("idleTimeBeforeSleepInSeconds", this.getIdleTimeBeforeSleepInSeconds());
        writer.writeStringValue("kioskAppDisplayName", this.getKioskAppDisplayName());
        writer.writeStringValue("kioskAppUserModelId", this.getKioskAppUserModelId());
        writer.writeLocalTimeValue("maintenanceStartTime", this.getMaintenanceStartTime());
    }

    public void setAccountManagerPolicy(@Nullable SharedPCAccountManagerPolicy value) {
        this.backingStore.set("accountManagerPolicy", (Object)value);
    }

    public void setAllowedAccounts(@Nullable EnumSet<SharedPCAllowedAccountType> value) {
        this.backingStore.set("allowedAccounts", value);
    }

    public void setAllowLocalStorage(@Nullable Boolean value) {
        this.backingStore.set("allowLocalStorage", (Object)value);
    }

    public void setDisableAccountManager(@Nullable Boolean value) {
        this.backingStore.set("disableAccountManager", (Object)value);
    }

    public void setDisableEduPolicies(@Nullable Boolean value) {
        this.backingStore.set("disableEduPolicies", (Object)value);
    }

    public void setDisablePowerPolicies(@Nullable Boolean value) {
        this.backingStore.set("disablePowerPolicies", (Object)value);
    }

    public void setDisableSignInOnResume(@Nullable Boolean value) {
        this.backingStore.set("disableSignInOnResume", (Object)value);
    }

    public void setEnabled(@Nullable Boolean value) {
        this.backingStore.set("enabled", (Object)value);
    }

    public void setIdleTimeBeforeSleepInSeconds(@Nullable Integer value) {
        this.backingStore.set("idleTimeBeforeSleepInSeconds", (Object)value);
    }

    public void setKioskAppDisplayName(@Nullable String value) {
        this.backingStore.set("kioskAppDisplayName", (Object)value);
    }

    public void setKioskAppUserModelId(@Nullable String value) {
        this.backingStore.set("kioskAppUserModelId", (Object)value);
    }

    public void setMaintenanceStartTime(@Nullable LocalTime value) {
        this.backingStore.set("maintenanceStartTime", (Object)value);
    }
}

