/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ActivityHistoryItem;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.Json;
import com.microsoft.graph.models.Status;
import com.microsoft.graph.models.VisualInfo;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UserActivity
extends Entity
implements Parsable {
    @Nonnull
    public static UserActivity createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserActivity();
    }

    @Nullable
    public String getActivationUrl() {
        return (String)this.backingStore.get("activationUrl");
    }

    @Nullable
    public String getActivitySourceHost() {
        return (String)this.backingStore.get("activitySourceHost");
    }

    @Nullable
    public String getAppActivityId() {
        return (String)this.backingStore.get("appActivityId");
    }

    @Nullable
    public String getAppDisplayName() {
        return (String)this.backingStore.get("appDisplayName");
    }

    @Nullable
    public Json getContentInfo() {
        return (Json)this.backingStore.get("contentInfo");
    }

    @Nullable
    public String getContentUrl() {
        return (String)this.backingStore.get("contentUrl");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public OffsetDateTime getExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("expirationDateTime");
    }

    @Nullable
    public String getFallbackUrl() {
        return (String)this.backingStore.get("fallbackUrl");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activationUrl", n -> this.setActivationUrl(n.getStringValue()));
        deserializerMap.put("activitySourceHost", n -> this.setActivitySourceHost(n.getStringValue()));
        deserializerMap.put("appActivityId", n -> this.setAppActivityId(n.getStringValue()));
        deserializerMap.put("appDisplayName", n -> this.setAppDisplayName(n.getStringValue()));
        deserializerMap.put("contentInfo", n -> this.setContentInfo((Json)n.getObjectValue(Json::createFromDiscriminatorValue)));
        deserializerMap.put("contentUrl", n -> this.setContentUrl(n.getStringValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("expirationDateTime", n -> this.setExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("fallbackUrl", n -> this.setFallbackUrl(n.getStringValue()));
        deserializerMap.put("historyItems", n -> this.setHistoryItems(n.getCollectionOfObjectValues(ActivityHistoryItem::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("status", n -> this.setStatus((Status)n.getEnumValue(Status::forValue)));
        deserializerMap.put("userTimezone", n -> this.setUserTimezone(n.getStringValue()));
        deserializerMap.put("visualElements", n -> this.setVisualElements((VisualInfo)n.getObjectValue(VisualInfo::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<ActivityHistoryItem> getHistoryItems() {
        return (List)this.backingStore.get("historyItems");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public Status getStatus() {
        return (Status)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public String getUserTimezone() {
        return (String)this.backingStore.get("userTimezone");
    }

    @Nullable
    public VisualInfo getVisualElements() {
        return (VisualInfo)this.backingStore.get("visualElements");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("activationUrl", this.getActivationUrl());
        writer.writeStringValue("activitySourceHost", this.getActivitySourceHost());
        writer.writeStringValue("appActivityId", this.getAppActivityId());
        writer.writeStringValue("appDisplayName", this.getAppDisplayName());
        writer.writeObjectValue("contentInfo", (Parsable)this.getContentInfo(), new Parsable[0]);
        writer.writeStringValue("contentUrl", this.getContentUrl());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeOffsetDateTimeValue("expirationDateTime", this.getExpirationDateTime());
        writer.writeStringValue("fallbackUrl", this.getFallbackUrl());
        writer.writeCollectionOfObjectValues("historyItems", this.getHistoryItems());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeStringValue("userTimezone", this.getUserTimezone());
        writer.writeObjectValue("visualElements", (Parsable)this.getVisualElements(), new Parsable[0]);
    }

    public void setActivationUrl(@Nullable String value) {
        this.backingStore.set("activationUrl", (Object)value);
    }

    public void setActivitySourceHost(@Nullable String value) {
        this.backingStore.set("activitySourceHost", (Object)value);
    }

    public void setAppActivityId(@Nullable String value) {
        this.backingStore.set("appActivityId", (Object)value);
    }

    public void setAppDisplayName(@Nullable String value) {
        this.backingStore.set("appDisplayName", (Object)value);
    }

    public void setContentInfo(@Nullable Json value) {
        this.backingStore.set("contentInfo", (Object)value);
    }

    public void setContentUrl(@Nullable String value) {
        this.backingStore.set("contentUrl", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("expirationDateTime", (Object)value);
    }

    public void setFallbackUrl(@Nullable String value) {
        this.backingStore.set("fallbackUrl", (Object)value);
    }

    public void setHistoryItems(@Nullable List<ActivityHistoryItem> value) {
        this.backingStore.set("historyItems", value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setStatus(@Nullable Status value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setUserTimezone(@Nullable String value) {
        this.backingStore.set("userTimezone", (Object)value);
    }

    public void setVisualElements(@Nullable VisualInfo value) {
        this.backingStore.set("visualElements", (Object)value);
    }
}

