/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.security.EdiscoveryReviewSetQuery;
import com.microsoft.graph.models.security.EdiscoverySearch;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Search
extends Entity
implements Parsable {
    @Nonnull
    public static Search createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.security.ediscoveryReviewSetQuery": {
                    return new EdiscoveryReviewSetQuery();
                }
                case "#microsoft.graph.security.ediscoverySearch": {
                    return new EdiscoverySearch();
                }
            }
        }
        return new Search();
    }

    @Nullable
    public String getContentQuery() {
        return (String)this.backingStore.get("contentQuery");
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("contentQuery", n -> this.setContentQuery(n.getStringValue()));
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getLastModifiedBy() {
        return (IdentitySet)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("contentQuery", this.getContentQuery());
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("lastModifiedBy", (Parsable)this.getLastModifiedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
    }

    public void setContentQuery(@Nullable String value) {
        this.backingStore.set("contentQuery", (Object)value);
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLastModifiedBy(@Nullable IdentitySet value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }
}

