package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class EventMessageDetail implements AdditionalDataHolder, BackedModel, Parsable {
    /**
     * Stores model information.
     */
    @jakarta.annotation.Nonnull
    protected BackingStore backingStore;
    /**
     * Instantiates a new {@link EventMessageDetail} and sets the default values.
     */
    public EventMessageDetail() {
        this.backingStore = BackingStoreFactorySingleton.instance.createBackingStore();
        this.setAdditionalData(new HashMap<>());
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link EventMessageDetail}
     */
    @jakarta.annotation.Nonnull
    public static EventMessageDetail createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        final ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            final String mappingValue = mappingValueNode.getStringValue();
            switch (mappingValue) {
                case "#microsoft.graph.callEndedEventMessageDetail": return new CallEndedEventMessageDetail();
                case "#microsoft.graph.callRecordingEventMessageDetail": return new CallRecordingEventMessageDetail();
                case "#microsoft.graph.callStartedEventMessageDetail": return new CallStartedEventMessageDetail();
                case "#microsoft.graph.callTranscriptEventMessageDetail": return new CallTranscriptEventMessageDetail();
                case "#microsoft.graph.channelAddedEventMessageDetail": return new ChannelAddedEventMessageDetail();
                case "#microsoft.graph.channelDeletedEventMessageDetail": return new ChannelDeletedEventMessageDetail();
                case "#microsoft.graph.channelDescriptionUpdatedEventMessageDetail": return new ChannelDescriptionUpdatedEventMessageDetail();
                case "#microsoft.graph.channelRenamedEventMessageDetail": return new ChannelRenamedEventMessageDetail();
                case "#microsoft.graph.channelSetAsFavoriteByDefaultEventMessageDetail": return new ChannelSetAsFavoriteByDefaultEventMessageDetail();
                case "#microsoft.graph.channelUnsetAsFavoriteByDefaultEventMessageDetail": return new ChannelUnsetAsFavoriteByDefaultEventMessageDetail();
                case "#microsoft.graph.chatRenamedEventMessageDetail": return new ChatRenamedEventMessageDetail();
                case "#microsoft.graph.conversationMemberRoleUpdatedEventMessageDetail": return new ConversationMemberRoleUpdatedEventMessageDetail();
                case "#microsoft.graph.meetingPolicyUpdatedEventMessageDetail": return new MeetingPolicyUpdatedEventMessageDetail();
                case "#microsoft.graph.membersAddedEventMessageDetail": return new MembersAddedEventMessageDetail();
                case "#microsoft.graph.membersDeletedEventMessageDetail": return new MembersDeletedEventMessageDetail();
                case "#microsoft.graph.membersJoinedEventMessageDetail": return new MembersJoinedEventMessageDetail();
                case "#microsoft.graph.membersLeftEventMessageDetail": return new MembersLeftEventMessageDetail();
                case "#microsoft.graph.messagePinnedEventMessageDetail": return new MessagePinnedEventMessageDetail();
                case "#microsoft.graph.messageUnpinnedEventMessageDetail": return new MessageUnpinnedEventMessageDetail();
                case "#microsoft.graph.tabUpdatedEventMessageDetail": return new TabUpdatedEventMessageDetail();
                case "#microsoft.graph.teamArchivedEventMessageDetail": return new TeamArchivedEventMessageDetail();
                case "#microsoft.graph.teamCreatedEventMessageDetail": return new TeamCreatedEventMessageDetail();
                case "#microsoft.graph.teamDescriptionUpdatedEventMessageDetail": return new TeamDescriptionUpdatedEventMessageDetail();
                case "#microsoft.graph.teamJoiningDisabledEventMessageDetail": return new TeamJoiningDisabledEventMessageDetail();
                case "#microsoft.graph.teamJoiningEnabledEventMessageDetail": return new TeamJoiningEnabledEventMessageDetail();
                case "#microsoft.graph.teamRenamedEventMessageDetail": return new TeamRenamedEventMessageDetail();
                case "#microsoft.graph.teamsAppInstalledEventMessageDetail": return new TeamsAppInstalledEventMessageDetail();
                case "#microsoft.graph.teamsAppRemovedEventMessageDetail": return new TeamsAppRemovedEventMessageDetail();
                case "#microsoft.graph.teamsAppUpgradedEventMessageDetail": return new TeamsAppUpgradedEventMessageDetail();
                case "#microsoft.graph.teamUnarchivedEventMessageDetail": return new TeamUnarchivedEventMessageDetail();
            }
        }
        return new EventMessageDetail();
    }
    /**
     * Gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @return a {@link Map<String, Object>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, Object> getAdditionalData() {
        Map<String, Object> value = this.backingStore.get("additionalData");
        if(value == null) {
            value = new HashMap<>();
            this.setAdditionalData(value);
        }
        return value;
    }
    /**
     * Gets the backingStore property value. Stores model information.
     * @return a {@link BackingStore}
     */
    @jakarta.annotation.Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(1);
        deserializerMap.put("@odata.type", (n) -> { this.setOdataType(n.getStringValue()); });
        return deserializerMap;
    }
    /**
     * Gets the @odata.type property value. The OdataType property
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getOdataType() {
        return this.backingStore.get("odataType");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }
    /**
     * Sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @param value Value to set for the AdditionalData property.
     */
    public void setAdditionalData(@jakarta.annotation.Nullable final Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }
    /**
     * Sets the backingStore property value. Stores model information.
     * @param value Value to set for the backingStore property.
     */
    public void setBackingStore(@jakarta.annotation.Nonnull final BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }
    /**
     * Sets the @odata.type property value. The OdataType property
     * @param value Value to set for the @odata.type property.
     */
    public void setOdataType(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("odataType", value);
    }
}
