/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.store;

import com.microsoft.kiota.TriConsumer;
import com.microsoft.kiota.store.BackingStore;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class InMemoryBackingStore
implements BackingStore {
    private boolean isInitializationCompleted = true;
    private boolean returnOnlyChangedValues;
    private final Map<String, Pair<Boolean, Object>> store = new HashMap<String, Pair<Boolean, Object>>();
    private final Map<String, TriConsumer<String, Object, Object>> subscriptionStore = new HashMap<String, TriConsumer<String, Object, Object>>();

    @Override
    public void setIsInitializationCompleted(boolean value) {
        this.isInitializationCompleted = value;
        for (Map.Entry<String, Pair<Boolean, Object>> entry : this.store.entrySet()) {
            Pair<Boolean, Object> wrapper = entry.getValue();
            Pair<Boolean, Object> updatedValue = wrapper.setValue0(!value);
            entry.setValue(updatedValue);
        }
    }

    @Override
    public boolean getIsInitializationCompleted() {
        return this.isInitializationCompleted;
    }

    @Override
    public void setReturnOnlyChangedValues(boolean value) {
        this.returnOnlyChangedValues = value;
    }

    @Override
    public boolean getReturnOnlyChangedValues() {
        return this.returnOnlyChangedValues;
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    @Nonnull
    public Map<String, Object> enumerate() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Pair<Boolean, Object>> entry : this.store.entrySet()) {
            Pair<Boolean, Object> wrapper = entry.getValue();
            Object value = this.getValueFromWrapper(wrapper);
            if (value == null) continue;
            result.put(entry.getKey(), wrapper.getValue1());
        }
        return result;
    }

    @Override
    @Nonnull
    public Iterable<String> enumerateKeysForValuesChangedToNull() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Pair<Boolean, Object>> entry : this.store.entrySet()) {
            Pair<Boolean, Object> wrapper = entry.getValue();
            Object value = wrapper.getValue1();
            if (value != null || !wrapper.getValue0().booleanValue()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private Object getValueFromWrapper(Pair<Boolean, Object> wrapper) {
        if (wrapper != null) {
            Boolean hasChanged = wrapper.getValue0();
            if (!this.returnOnlyChangedValues || this.returnOnlyChangedValues && hasChanged != null && hasChanged.booleanValue()) {
                return wrapper.getValue1();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T get(@Nonnull String key) {
        Objects.requireNonNull(key);
        Pair<Boolean, Object> wrapper = this.store.get(key);
        Object value = this.getValueFromWrapper(wrapper);
        try {
            return (T)value;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    @Override
    public <T> void set(@Nonnull String key, @Nullable T value) {
        Objects.requireNonNull(key);
        Pair<Boolean, T> valueToAdd = new Pair<Boolean, T>(this.isInitializationCompleted, value);
        Pair<Boolean, T> oldValue = this.store.put(key, valueToAdd);
        for (TriConsumer<String, Object, Object> callback : this.subscriptionStore.values()) {
            callback.accept(key, oldValue.getValue1(), value);
        }
    }

    @Override
    public void unsubscribe(@Nonnull String subscriptionId) {
        Objects.requireNonNull(subscriptionId);
        this.subscriptionStore.remove(subscriptionId);
    }

    @Override
    @Nonnull
    public String subscribe(@Nonnull TriConsumer<String, Object, Object> callback) {
        String subscriptionId = UUID.randomUUID().toString();
        this.subscribe(subscriptionId, callback);
        return subscriptionId;
    }

    @Override
    public void subscribe(@Nonnull String subscriptionId, @Nonnull TriConsumer<String, Object, Object> callback) {
        Objects.requireNonNull(callback);
        Objects.requireNonNull(subscriptionId);
        this.subscriptionStore.put(subscriptionId, callback);
    }

    private static class Pair<A, B> {
        private final A value0;
        private final B value1;

        public Pair(A value0, B value1) {
            this.value0 = value0;
            this.value1 = value1;
        }

        public A getValue0() {
            return this.value0;
        }

        public Pair<A, B> setValue0(A value0) {
            return new Pair<A, B>(value0, this.value1);
        }

        public B getValue1() {
            return this.value1;
        }

        public Pair<A, B> setValue1(B value1) {
            return new Pair<A, B>(this.value0, value1);
        }
    }
}

