/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.authentication;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.microsoft.kiota.authentication.AccessTokenProvider;
import com.microsoft.kiota.authentication.AllowedHostsValidator;
import com.microsoft.kiota.authentication.ObservabilityOptions;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class AzureIdentityAccessTokenProvider
implements AccessTokenProvider {
    private final TokenCredential creds;
    private final List<String> _scopes;
    private final AllowedHostsValidator _hostValidator;
    private final ObservabilityOptions _observabilityOptions;
    private static final HashSet<String> localhostStrings = new HashSet<String>(Arrays.asList("localhost", "[::1]", "::1", "127.0.0.1"));
    private static final String ClaimsKey = "claims";
    private static final String parentSpanKey = "parent-span";

    public AzureIdentityAccessTokenProvider(@Nonnull TokenCredential tokenCredential, @Nonnull String[] allowedHosts, String ... scopes) {
        this(tokenCredential, allowedHosts, (ObservabilityOptions)null, scopes);
    }

    public AzureIdentityAccessTokenProvider(@Nonnull TokenCredential tokenCredential, @Nonnull String[] allowedHosts, @Nullable ObservabilityOptions observabilityOptions, String ... scopes) {
        this.creds = Objects.requireNonNull(tokenCredential, "parameter tokenCredential cannot be null");
        this._scopes = scopes == null ? new ArrayList<String>() : Arrays.asList(scopes);
        this._hostValidator = allowedHosts == null || allowedHosts.length == 0 ? new AllowedHostsValidator(new String[0]) : new AllowedHostsValidator(allowedHosts);
        this._observabilityOptions = observabilityOptions == null ? new ObservabilityOptions() : observabilityOptions;
    }

    @Nonnull
    public String getAuthorizationToken(@Nonnull URI uri, @Nullable Map<String, Object> additionalAuthenticationContext) {
        Span span;
        if (additionalAuthenticationContext != null && additionalAuthenticationContext.containsKey(parentSpanKey) && additionalAuthenticationContext.get(parentSpanKey) instanceof Span) {
            Span parentSpan = (Span)additionalAuthenticationContext.get(parentSpanKey);
            span = GlobalOpenTelemetry.getTracer((String)this._observabilityOptions.getTracerInstrumentationName()).spanBuilder("getAuthorizationToken").setParent(Context.current().with((ImplicitContextKeyed)parentSpan)).startSpan();
        } else {
            span = GlobalOpenTelemetry.getTracer((String)this._observabilityOptions.getTracerInstrumentationName()).spanBuilder("getAuthorizationToken").startSpan();
        }
        try {
            String string;
            block23: {
                Scope scope;
                block21: {
                    String string2;
                    block22: {
                        scope = span.makeCurrent();
                        try {
                            if (this._hostValidator.isUrlHostValid(uri)) break block21;
                            span.setAttribute("com.microsoft.kiota.authentication.is_url_valid", false);
                            string2 = "";
                            if (scope == null) break block22;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (scope != null) {
                                    try {
                                        scope.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IllegalArgumentException e) {
                                span.recordException((Throwable)e);
                                throw e;
                            }
                        }
                        scope.close();
                    }
                    return string2;
                }
                if (!uri.getScheme().equalsIgnoreCase("https") && !AzureIdentityAccessTokenProvider.isLocalhostUrl(uri.getHost())) {
                    span.setAttribute("com.microsoft.kiota.authentication.is_url_valid", false);
                    throw new IllegalArgumentException("Only https is supported");
                }
                span.setAttribute("com.microsoft.kiota.authentication.is_url_valid", true);
                String decodedClaim = null;
                if (additionalAuthenticationContext != null && additionalAuthenticationContext.containsKey(ClaimsKey) && additionalAuthenticationContext.get(ClaimsKey) instanceof String) {
                    String rawClaim = (String)additionalAuthenticationContext.get(ClaimsKey);
                    try {
                        decodedClaim = new String(Base64.getDecoder().decode(rawClaim), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        span.recordException((Throwable)e);
                    }
                }
                span.setAttribute("com.microsoft.kiota.authentication.additional_claims_provided", decodedClaim != null && !decodedClaim.isEmpty());
                TokenRequestContext context = new TokenRequestContext();
                if (this._scopes.isEmpty()) {
                    this._scopes.add(uri.getScheme() + "://" + uri.getHost() + "/.default");
                }
                context.setScopes(this._scopes);
                span.setAttribute("com.microsoft.kiota.authentication.scopes", String.join((CharSequence)"|", this._scopes));
                if (decodedClaim != null && !decodedClaim.isEmpty()) {
                    context.setClaims(decodedClaim);
                }
                string = this.creds.getTokenSync(context).getToken();
                if (scope == null) break block23;
                scope.close();
            }
            return string;
        }
        finally {
            span.end();
        }
    }

    @Nonnull
    public AllowedHostsValidator getAllowedHostsValidator() {
        return this._hostValidator;
    }

    private static boolean isLocalhostUrl(@Nonnull String host) {
        Objects.requireNonNull(host);
        return localhostStrings.contains(host.toLowerCase(Locale.ROOT));
    }
}

