/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.credentials.ServiceClientCredentials;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.io.IOException;

public class CredentialsPolicyFactory
implements RequestPolicyFactory {
    private final ServiceClientCredentials credentials;

    public CredentialsPolicyFactory(ServiceClientCredentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new CredentialsPolicy(next);
    }

    private final class CredentialsPolicy
    implements RequestPolicy {
        private final RequestPolicy next;

        private CredentialsPolicy(RequestPolicy next) {
            this.next = next;
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            try {
                String token = CredentialsPolicyFactory.this.credentials.authorizationHeaderValue(request.url().toString());
                request.headers().set("Authorization", token);
                return this.next.sendAsync(request);
            }
            catch (IOException e) {
                return Single.error((Throwable)e);
            }
        }
    }
}

