/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.http.HttpPipelineLogLevel;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.http.UrlBuilder;
import com.microsoft.rest.v2.policy.AbstractRequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.net.MalformedURLException;

public class ProtocolPolicyFactory
implements RequestPolicyFactory {
    private final String protocol;
    private final boolean overwrite;

    public ProtocolPolicyFactory(String protocol) {
        this(protocol, true);
    }

    public ProtocolPolicyFactory(String protocol, boolean overwrite) {
        this.protocol = protocol;
        this.overwrite = overwrite;
    }

    @Override
    public ProtocolPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new ProtocolPolicy(next, options);
    }

    private class ProtocolPolicy
    extends AbstractRequestPolicy {
        ProtocolPolicy(RequestPolicy nextPolicy, RequestPolicyOptions options) {
            super(nextPolicy, options);
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            UrlBuilder urlBuilder = UrlBuilder.parse(request.url());
            if (ProtocolPolicyFactory.this.overwrite || urlBuilder.scheme() == null) {
                if (this.shouldLog(HttpPipelineLogLevel.INFO)) {
                    this.log(HttpPipelineLogLevel.INFO, "Setting protocol to {0}", ProtocolPolicyFactory.this.protocol);
                }
                try {
                    request.withUrl(urlBuilder.withScheme(ProtocolPolicyFactory.this.protocol).toURL());
                }
                catch (MalformedURLException e) {
                    return Single.error((Throwable)e);
                }
            }
            return this.nextPolicy().sendAsync(request);
        }
    }
}

