/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DBComms;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamArgs;
import com.microsoft.sqlserver.jdbc.PacketRequestor;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.StreamColumns;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamError;
import com.microsoft.sqlserver.jdbc.StreamLoginAck;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import com.microsoft.sqlserver.jdbc.TdsTransactionDescriptor;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class IOBuffer {
    int nOutIndex;
    private boolean bFirstPacketSent = false;
    int nCharIndex;
    int nInIndex;
    int nRecvSize;
    private DBComms dbCom;
    byte[] binDataBuffer;
    char[] charDataBuffer;
    int nLastRetStatIndex;
    Vector sqlWarnings;
    private StreamDone streamDone;
    private static Logger tdsDiagLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDS.TOKEN");
    private static final byte ENVCHANGE_DATABASE = 1;
    private static final byte ENVCHANGE_LANGUAGE = 2;
    private static final byte ENVCHANGE_CHARSET = 3;
    private static final byte ENVCHANGE_PACKETSIZE = 4;
    private static final byte ENVCHANGE_SORTLOCALEID = 5;
    private static final byte ENVCHANGE_SORTFLAGS = 6;
    private static final byte ENVCHANGE_SQLCOLLATION = 7;
    private static final byte ENVCHANGE_XACT_BEGIN = 8;
    private static final byte ENVCHANGE_XACT_COMMIT = 9;
    private static final byte ENVCHANGE_XACT_ROLLBACK = 10;
    private static final byte ENVCHANGE_DTC_ENLIST = 11;
    private static final byte ENVCHANGE_DTC_DEFECT = 12;
    private static final byte ENVCHANGE_CHANGE_MIRROR = 13;
    private static final byte ENVCHANGE_UNUSED_14 = 14;
    private static final byte ENVCHANGE_DTC_PROMOTE = 15;
    private static final byte ENVCHANGE_DTC_MGR_ADDR = 16;
    private static final byte ENVCHANGE_XACT_ENDED = 17;
    private static final byte ENVCHANGE_RESET_COMPLETE = 18;
    private static final byte ENVCHANGE_USER_INFO = 19;

    IOBuffer() {
        this.extendByteBuffer(256);
        this.extendCharBuffer(256);
        this.streamDone = new StreamDone(-3);
    }

    IOBuffer(DBComms dBComms, int n) {
        this.extendByteBuffer(n);
        this.extendCharBuffer(256);
        this.streamDone = new StreamDone(-3);
        this.dbCom = dBComms;
    }

    final DBComms getDbCom() {
        return this.dbCom;
    }

    final void setDbCom(DBComms dBComms) {
        this.dbCom = dBComms;
    }

    final boolean sentFirstPacket() {
        return this.bFirstPacketSent;
    }

    final void resetSendBuffer() {
        this.nOutIndex = 0;
        this.bFirstPacketSent = false;
    }

    final String instanceId() {
        String string = "" + this;
        int n = string.length();
        String string2 = "" + this.dbCom;
        int n2 = string2.length();
        if (n2 < 5) {
            n2 = 5;
        }
        if (n < 5) {
            n = 5;
        }
        String string3 = "[" + Thread.currentThread() + ", IO:" + string.substring(n - 5) + ", Dbc:" + string2.substring(n2 - 5) + "]";
        return string3;
    }

    final SQLServerConnection getSQLServerConnection() {
        if (this instanceof SQLServerConnection) {
            return (SQLServerConnection)this;
        }
        if (this instanceof SQLServerStatement) {
            return ((SQLServerStatement)this).connection;
        }
        return null;
    }

    void extendByteBuffer(int n) {
        if (n < 1024) {
            n = 1024;
        }
        int n2 = 0;
        if (this.binDataBuffer != null) {
            n2 = this.binDataBuffer.length;
        }
        byte[] byArray = new byte[n2 + n];
        if (n2 > 0) {
            System.arraycopy(this.binDataBuffer, 0, byArray, 0, n2);
            this.binDataBuffer = null;
        }
        this.binDataBuffer = null;
        this.binDataBuffer = byArray;
        byArray = null;
    }

    void extendCharBuffer(int n) {
        if (n < 1024) {
            n = 1024;
        }
        int n2 = 0;
        if (this.charDataBuffer != null) {
            n2 = this.charDataBuffer.length;
        }
        char[] cArray = new char[n2 + n];
        if (n2 > 0) {
            System.arraycopy(this.charDataBuffer, 0, cArray, 0, n2);
            this.charDataBuffer = null;
        }
        this.charDataBuffer = null;
        this.charDataBuffer = cArray;
        cArray = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendCommand(byte by, int n, boolean bl) throws SQLServerException {
        DBComms dBComms = this.dbCom;
        synchronized (dBComms) {
            this.dbCom.aquireExclusiveUse(this);
            this.dbCom.transmit(by, this, n, 0, bl);
            this.bFirstPacketSent = false;
            if (by != 6) {
                this.dbCom.receive(by, this, n, bl);
            }
        }
    }

    final void resetInBuffer() {
        this.nRecvSize = 0;
        this.nInIndex = 0;
    }

    final boolean pastEndBuffer() {
        return this.nInIndex >= this.nRecvSize;
    }

    private final String packetName(byte by) {
        String string = "";
        switch (by) {
            case -86: {
                string = "ERR";
                break;
            }
            case -85: {
                string = "MSG";
                break;
            }
            case -3: {
                string = "DONE";
                break;
            }
            case -47: {
                string = "ROW";
                break;
            }
            case -2: {
                string = "DONEPROC";
                break;
            }
            case -1: {
                string = "DONEINPROC";
                break;
            }
            case 121: {
                string = "RET_STAT";
                break;
            }
            case -84: {
                string = "RET_VAL";
                break;
            }
            case -127: {
                string = "COLMETADATA";
                break;
            }
            case -92: {
                string = "TABNAME";
                break;
            }
            case -87: {
                string = "ORDER";
                break;
            }
            case -91: {
                string = "COLINFO";
                break;
            }
            case 124: {
                string = "PROCID";
                break;
            }
            case -29: {
                string = "ENVCHANGE";
                break;
            }
            case -83: {
                string = "LOGINACK";
            }
        }
        return "TDS_" + string + "(" + by + ")";
    }

    final StreamPacket processPackets(SQLServerConnection sQLServerConnection, PacketRequestor[] packetRequestorArray, int n, String string, boolean bl) throws SQLServerException {
        int n2;
        Serializable serializable;
        int n3 = 0;
        boolean bl2 = false;
        Object object = null;
        byte[] byArray = null;
        int n4 = n;
        boolean bl3 = false;
        this.sqlWarnings = null;
        StreamError streamError = null;
        int n5 = 0;
        if (tdsDiagLogger.isLoggable(Level.FINEST)) {
            serializable = new StringBuffer("------------- Start IOBuff.processPackets " + string + " --------------------\r\n" + "Looking for:");
            for (n2 = 0; n2 < n4; ++n2) {
                ((StringBuffer)serializable).append(" " + this.packetName((byte)packetRequestorArray[n2].nPacketType));
            }
            this.logTDSDiag(((StringBuffer)serializable).toString());
        }
        while (!bl3) {
            if (this.nInIndex >= this.nRecvSize) {
                if (null != streamError) {
                    this.nInIndex = n5;
                    SQLServerException.makeFromDatabaseError(sQLServerConnection, this, streamError.getMessage(), streamError, false);
                }
                if (bl) {
                    return null;
                }
                serializable = new MessageFormat(SQLServerException.getErrString("R_exhaustedInput"));
                Object[] objectArray = new Object[]{string};
                String string2 = ((Format)serializable).format(objectArray);
                for (int i = 0; i < n4; ++i) {
                    string2 = string2 + this.packetName((byte)packetRequestorArray[i].nPacketType) + " ";
                }
                SQLException sQLException = new SQLException(string2);
                sQLServerConnection.notifyPooledConnection(sQLException);
                SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, string2, null, true);
            }
            byte by = this.binDataBuffer[this.nInIndex++];
            n2 = -1;
            for (int i = 0; i < n4; ++i) {
                if (by != packetRequestorArray[i].nPacketType) continue;
                n2 = i;
                break;
            }
            if (tdsDiagLogger.isLoggable(Level.FINEST)) {
                this.logTDSDiag(this.packetName(by) + " at:" + (this.nInIndex - 1));
            }
            switch (by) {
                case -3: 
                case -1: {
                    if (n2 >= 0) {
                        if (!packetRequestorArray[n2].bEatPacket) {
                            packetRequestorArray[n2].bFound = true;
                            --this.nInIndex;
                            object = null;
                            bl3 = true;
                            break;
                        }
                        this.streamDone.setData(by, this.binDataBuffer, this.nInIndex, this.dbCom.getTDSVersion());
                        if (this.streamDone.isFinal()) {
                            object = this.streamDone;
                        }
                        if (this.streamDone.hasCount()) {
                            object = this.streamDone;
                        }
                    }
                    if (n2 >= 0 && packetRequestorArray[n2].bDONEINPROCUnconditional) {
                        object = this.streamDone;
                    }
                    this.nInIndex += 8;
                    if (!this.dbCom.getTDSVersion().isYukonOrLater()) break;
                    this.nInIndex += 4;
                    break;
                }
                case -2: {
                    if (n2 >= 0) {
                        this.streamDone.setData(by, this.binDataBuffer, this.nInIndex, this.dbCom.getTDSVersion());
                        if (this.streamDone.isFinal()) {
                            object = this.streamDone;
                        }
                    }
                    this.nInIndex += 8;
                    if (!this.dbCom.getTDSVersion().isYukonOrLater()) break;
                    this.nInIndex += 4;
                    break;
                }
                case -127: {
                    if (n2 >= 0 && !packetRequestorArray[n2].bEatPacket) {
                        packetRequestorArray[n2].bFound = true;
                        --this.nInIndex;
                        object = null;
                        bl3 = true;
                        break;
                    }
                    StreamColumns streamColumns = new StreamColumns();
                    int n6 = streamColumns.processBytes(by, this.getSQLServerConnection(), this.binDataBuffer, this.nInIndex, this.dbCom.getTDSVersion());
                    this.nInIndex += n6;
                    if (n2 < 0) break;
                    object = streamColumns;
                    break;
                }
                case -47: {
                    Object object2;
                    if (n2 >= 0 && !packetRequestorArray[n2].bEatPacket) {
                        packetRequestorArray[n2].bFound = true;
                        --this.nInIndex;
                        object = null;
                        bl3 = true;
                        break;
                    }
                    if (null == streamError) {
                        String string3 = SQLServerException.getErrString("R_unexpectedPacket");
                        object2 = new SQLException(string3);
                        sQLServerConnection.notifyPooledConnection((Exception)object2);
                        SQLServerException.makeFromDriverError(sQLServerConnection, this, string3, null, true);
                    } else {
                        this.nInIndex = n5;
                        SQLServerException.makeFromDatabaseError(sQLServerConnection, this, streamError.getMessage(), streamError, false);
                    }
                }
                case 121: {
                    if (n2 >= 0 && !packetRequestorArray[n2].bEatPacket) {
                        packetRequestorArray[n2].bFound = true;
                        --this.nInIndex;
                        object = null;
                        bl3 = true;
                        break;
                    }
                    this.nLastRetStatIndex = this.nInIndex - 1;
                    this.nInIndex += 4;
                    break;
                }
                case -84: {
                    if (n2 >= 0 && !packetRequestorArray[n2].bEatPacket) {
                        packetRequestorArray[n2].bFound = true;
                        --this.nInIndex;
                        object = null;
                        bl3 = true;
                        break;
                    }
                    this.nInIndex += 2;
                    Object object2 = new StreamRetValue(new Parameter());
                    this.nInIndex = ((StreamRetValue)object2).deserialize(this.binDataBuffer, this.nInIndex, this.dbCom.getTDSVersion());
                    if (n2 < 0) break;
                    object = object2;
                    break;
                }
                case -91: 
                case -89: 
                case -88: 
                case -30: {
                    n3 = (this.binDataBuffer[this.nInIndex++] & 0xFF) + ((this.binDataBuffer[this.nInIndex++] & 0xFF) << 8);
                    this.nInIndex += n3;
                    break;
                }
                case -29: {
                    this.processEnvChange();
                    break;
                }
                case -83: {
                    n3 = (this.binDataBuffer[this.nInIndex++] & 0xFF) + ((this.binDataBuffer[this.nInIndex++] & 0xFF) << 8);
                    if (n2 >= 0) {
                        byArray = new byte[n3];
                        System.arraycopy(this.binDataBuffer, this.nInIndex, byArray, 0, n3);
                        object = new StreamLoginAck(byArray);
                    }
                    this.nInIndex += n3;
                    break;
                }
                case -86: 
                case -85: {
                    SQLException sQLException;
                    Object object3;
                    Serializable serializable2;
                    n3 = (this.binDataBuffer[this.nInIndex++] & 0xFF) + ((this.binDataBuffer[this.nInIndex++] & 0xFF) << 8);
                    byArray = new byte[n3];
                    System.arraycopy(this.binDataBuffer, this.nInIndex, byArray, 0, n3);
                    if (by == -86) {
                        object = new StreamError(byArray, this.dbCom.getTDSVersion());
                    } else {
                        serializable2 = new StreamError(byArray, this.dbCom.getTDSVersion());
                        object3 = new SQLWarning(((StreamError)serializable2).getMessage(), SQLServerException.generateStateCode(this.getSQLServerConnection(), ((StreamError)serializable2).getErrorNumber(), ((StreamError)serializable2).getErrorState()), ((StreamError)serializable2).getErrorNumber());
                        if (this.sqlWarnings == null) {
                            this.sqlWarnings = new Vector();
                        } else {
                            int n7 = this.sqlWarnings.size();
                            sQLException = (SQLWarning)this.sqlWarnings.elementAt(n7 - 1);
                            ((SQLWarning)sQLException).setNextWarning((SQLWarning)object3);
                        }
                        this.sqlWarnings.add(object3);
                    }
                    this.nInIndex += n3;
                    break;
                }
                case -92: 
                case -87: {
                    n3 = (this.binDataBuffer[this.nInIndex++] & 0xFF) + ((this.binDataBuffer[this.nInIndex++] & 0xFF) << 8);
                    this.nInIndex += n3;
                    break;
                }
                case 124: {
                    this.nInIndex += 8;
                    break;
                }
                default: {
                    Serializable serializable2 = new MessageFormat(SQLServerException.getErrString("R_unknownPacket"));
                    Object object3 = new Object[]{new Byte(by), new Integer(this.nInIndex - 1), new Integer(this.nRecvSize)};
                    String string4 = ((Format)serializable2).format(object3);
                    for (int i = 0; i < n4; ++i) {
                        string4 = string4 + this.packetName((byte)packetRequestorArray[i].nPacketType) + " ";
                    }
                    SQLException sQLException = new SQLException(string4);
                    sQLServerConnection.notifyPooledConnection(sQLException);
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, string4, null, true);
                }
            }
            if (null == streamError && object instanceof StreamError) {
                StreamError streamError2 = (StreamError)object;
                if (streamError2.getErrorSeverity() >= 16 && streamError2.getErrorSeverity() < 20 && this.dbCom.getTDSVersion().isYukonOrLater()) {
                    n4 = 0;
                    streamError = streamError2;
                    n5 = this.nInIndex;
                } else {
                    SQLServerException.makeFromDatabaseError(sQLServerConnection, this, streamError2.getMessage(), streamError2, false);
                }
            }
            if (null != streamError) {
                bl3 = false;
                continue;
            }
            if (object == null && !bl3) continue;
            return object;
        }
        return null;
    }

    private final void processEnvChange() throws SQLServerException {
        int n = (this.binDataBuffer[this.nInIndex++] & 0xFF) + ((this.binDataBuffer[this.nInIndex++] & 0xFF) << 8);
        int n2 = this.nInIndex;
        byte by = this.binDataBuffer[n2++];
        switch (by) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 7: {
                byte by2 = this.binDataBuffer[n2++];
                if (5 != by2) {
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, SQLServerException.getErrString("R_invalidTDS"), null, true);
                }
                this.dbCom.setDatabaseCollation(new SQLCollation(this.binDataBuffer, n2));
                break;
            }
            case 8: 
            case 11: {
                if (!this.dbCom.getTDSVersion().isYukonOrLater()) break;
                TdsTransactionDescriptor tdsTransactionDescriptor = this.getSQLServerConnection().getTransactionDescriptor();
                byte by3 = this.binDataBuffer[n2++];
                if (tdsTransactionDescriptor.getSize() != by3) break;
                tdsTransactionDescriptor.deserialize(this.binDataBuffer, n2);
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                if (!this.dbCom.getTDSVersion().isYukonOrLater()) break;
                this.getSQLServerConnection().getTransactionDescriptor().clear();
                break;
            }
            case 1: {
                int n3 = 2 * this.binDataBuffer[n2++];
                try {
                    this.getSQLServerConnection().setCatalogName(new String(this.binDataBuffer, n2, n3, "UTF-16LE"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, unsupportedEncodingException.toString(), null, true);
                }
                break;
            }
            case 13: {
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
        }
        this.nInIndex += n;
    }

    final void cbufferAppendString(String string) {
        int n = string.length();
        if (this.nCharIndex + n > this.charDataBuffer.length) {
            this.extendCharBuffer(n);
        }
        string.getChars(0, n, this.charDataBuffer, this.nCharIndex);
        this.nCharIndex += n;
    }

    final void cbufferInsertString(String string) {
        int n = string.length();
        if (this.nCharIndex + n > this.charDataBuffer.length) {
            this.extendCharBuffer(n);
        }
        System.arraycopy(this.charDataBuffer, 0, this.charDataBuffer, n, this.nCharIndex);
        string.getChars(0, n, this.charDataBuffer, 0);
        this.nCharIndex += n;
    }

    final void cbufferAppendChar(char c) {
        if (this.nCharIndex + 1 > this.charDataBuffer.length) {
            this.extendCharBuffer(1);
        }
        this.charDataBuffer[this.nCharIndex++] = c;
    }

    final void cbufferEnsureCapacity(int n) {
        int n2 = n - (this.charDataBuffer.length - this.nCharIndex);
        if (n2 > 0) {
            this.extendCharBuffer(n2);
        }
    }

    final String cbufferToString() {
        String string = new String(this.charDataBuffer, 0, this.nCharIndex);
        this.nCharIndex = 0;
        return string;
    }

    private void setStringControlCharacters() {
        this.nOutIndex += this.dbCom.getDatabaseCollation().writeCollation(this.binDataBuffer, this.nOutIndex);
    }

    final void bufferAppendByteArray(byte[] byArray) {
        int n = byArray.length;
        if (this.nOutIndex + n > this.binDataBuffer.length) {
            this.extendByteBuffer(n);
        }
        System.arraycopy(byArray, 0, this.binDataBuffer, this.nOutIndex, n);
        this.nOutIndex += n;
    }

    final void appendByteParam(byte[] byArray) throws SQLServerException {
        this.bufferAppendByte((byte)0);
        this.bufferAppendByte((byte)0);
        this.bufferAppendByte((byte)-91);
        this.bufferAppendShort((short)8000);
        int n = byArray.length;
        this.bufferAppendShort((short)n);
        for (int i = 0; i < n; ++i) {
            this.bufferAppendByte(byArray[i]);
        }
    }

    final void bufferAppendString(String string) {
        int n = string.length();
        int n2 = n * 2;
        if (this.nOutIndex + n2 > this.binDataBuffer.length) {
            this.extendByteBuffer(n2);
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.binDataBuffer[this.nOutIndex++] = (byte)(c & 0xFF);
            this.binDataBuffer[this.nOutIndex++] = (byte)(c >> 8 & 0xFF);
        }
    }

    final void bufferAppendByte(byte by) {
        if (this.nOutIndex + 1 > this.binDataBuffer.length) {
            this.extendByteBuffer(1);
        }
        this.binDataBuffer[this.nOutIndex++] = by;
    }

    final void bufferAppendShort(short s) {
        int n = 2;
        if (this.nOutIndex + n > this.binDataBuffer.length) {
            this.extendByteBuffer(n);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)(s >> 0 & 0xFF);
        this.binDataBuffer[this.nOutIndex++] = (byte)(s >> 8 & 0xFF);
    }

    final void bufferAppendTinyInt(short s) {
        byte by = (byte)(s >> 0 & 0xFF);
        this.bufferAppendByte(by);
    }

    final void bufferAppendInt(int n) {
        int n2 = 4;
        if (this.nOutIndex + n2 > this.binDataBuffer.length) {
            this.extendByteBuffer(n2);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)(n >> 0 & 0xFF);
        this.binDataBuffer[this.nOutIndex++] = (byte)(n >> 8 & 0xFF);
        this.binDataBuffer[this.nOutIndex++] = (byte)(n >> 16 & 0xFF);
        this.binDataBuffer[this.nOutIndex++] = (byte)(n >> 24 & 0xFF);
    }

    final void bufferAppendLong(long l) {
        int n = 8;
        if (this.nOutIndex + n > this.binDataBuffer.length) {
            this.extendByteBuffer(n);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)(l >> 0 & 0xFFL);
        this.binDataBuffer[this.nOutIndex++] = (byte)(l >> 8 & 0xFFL);
        this.binDataBuffer[this.nOutIndex++] = (byte)(l >> 16 & 0xFFL);
        this.binDataBuffer[this.nOutIndex++] = (byte)(l >> 24 & 0xFFL);
        this.binDataBuffer[this.nOutIndex++] = (byte)(l >> 32 & 0xFFL);
        this.binDataBuffer[this.nOutIndex++] = (byte)(l >> 40 & 0xFFL);
        this.binDataBuffer[this.nOutIndex++] = (byte)(l >> 48 & 0xFFL);
        this.binDataBuffer[this.nOutIndex++] = (byte)(l >> 56 & 0xFFL);
    }

    final void bufferAppendRPCInt(String string, Integer n, boolean bl) {
        this.bufferAppendRPCNameValType(string, bl, 38);
        this.binDataBuffer[this.nOutIndex++] = 4;
        if (null == n) {
            this.binDataBuffer[this.nOutIndex++] = 0;
        } else {
            this.binDataBuffer[this.nOutIndex++] = 4;
            this.bufferAppendInt(n);
        }
    }

    final void bufferAppendRPCLong(String string, Long l, boolean bl) {
        this.bufferAppendRPCNameValType(string, bl, 38);
        this.binDataBuffer[this.nOutIndex++] = 8;
        if (null == l) {
            this.binDataBuffer[this.nOutIndex++] = 0;
        } else {
            this.binDataBuffer[this.nOutIndex++] = 8;
            this.bufferAppendLong(l);
        }
    }

    final void bufferAppendRPCShort(String string, Short s, boolean bl) {
        this.bufferAppendRPCNameValType(string, bl, 38);
        this.binDataBuffer[this.nOutIndex++] = 2;
        if (null == s) {
            this.binDataBuffer[this.nOutIndex++] = 0;
        } else {
            this.binDataBuffer[this.nOutIndex++] = 2;
            this.bufferAppendShort(s);
        }
    }

    final void bufferAppendRPCByte(String string, Byte by, boolean bl) {
        this.bufferAppendRPCNameValType(string, bl, 38);
        this.binDataBuffer[this.nOutIndex++] = 1;
        if (null == by) {
            this.binDataBuffer[this.nOutIndex++] = 0;
        } else {
            this.binDataBuffer[this.nOutIndex++] = 1;
            this.bufferAppendTinyInt(by.byteValue());
        }
    }

    final void bufferAppendRPCBit(String string, Boolean bl, boolean bl2) {
        this.bufferAppendRPCNameValType(string, bl2, 104);
        this.binDataBuffer[this.nOutIndex++] = 1;
        if (null == bl) {
            this.binDataBuffer[this.nOutIndex++] = 0;
        } else {
            this.binDataBuffer[this.nOutIndex++] = 1;
            this.bufferAppendByte((byte)(bl != false ? 1 : 0));
        }
    }

    final void bufferAppendRPCNameValType(String string, boolean bl, int n) {
        boolean bl2 = string == null;
        int n2 = 16;
        int n3 = 0;
        boolean bl3 = false;
        if (!bl2) {
            n3 = string.length() + 1;
            n2 += n3 * 2;
        }
        if (this.nOutIndex + n2 > this.binDataBuffer.length) {
            this.extendByteBuffer(n2);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)n3;
        if (n3 > 0) {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 0;
            this.bufferAppendString(string);
        }
        this.binDataBuffer[this.nOutIndex++] = bl ? (byte)1 : 0;
        this.binDataBuffer[this.nOutIndex++] = (byte)n;
    }

    final void bufferAppendRPCStringUnicode(String string, String string2, boolean bl) {
        this.bufferAppendRPCStringUnicode(string, string2, bl, 12);
    }

    final void bufferAppendRPCStringUnicode(String string, String string2, boolean bl, int n) {
        boolean bl2 = string == null;
        boolean bl3 = string2 == null;
        boolean bl4 = this.dbCom.getTDSVersion().isYukonOrLater() && 1 != n && bl;
        int n2 = 17;
        int n3 = 0;
        int n4 = 0;
        if (!bl2) {
            n3 = string.length() + 1;
            n2 += n3 * 2;
        }
        if (!bl3) {
            n4 = string2.length() * 2;
            n2 += n4;
        }
        if (this.nOutIndex + n2 > this.binDataBuffer.length) {
            this.extendByteBuffer(n2);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)n3;
        if (n3 > 0) {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 0;
            this.bufferAppendString(string);
        }
        this.binDataBuffer[this.nOutIndex++] = bl ? (byte)1 : 0;
        this.binDataBuffer[this.nOutIndex++] = -25;
        if (bl4) {
            this.bufferAppendVMaxHeader(n4, bl3, true);
            if (bl3 || 0 == n4) {
                return;
            }
            this.bufferAppendString(string2);
            this.bufferAppendInt(0);
        } else {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 31;
            this.setStringControlCharacters();
            if (bl3) {
                this.bufferAppendShort((short)-1);
            } else {
                this.bufferAppendShort((short)n4);
                if (0 == n4) {
                    return;
                }
                this.bufferAppendString(string2);
            }
        }
    }

    final void bufferAppendRPCStringNonUnicode(String string, String string2, boolean bl, int n) throws SQLServerException {
        boolean bl2 = string == null;
        boolean bl3 = string2 == null;
        boolean bl4 = this.dbCom.getTDSVersion().isYukonOrLater() && 1 != n && bl;
        int n2 = 17;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        if (!bl2) {
            n3 = string.length() + 1;
            n2 += n3 * 2;
        }
        if (!bl3) {
            try {
                byArray = string2.getBytes(this.dbCom.getDatabaseCharset());
                n4 = byArray.length;
            }
            catch (Exception exception) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_encodingErrorWritingTDS"));
                Object[] objectArray = new Object[]{new String(exception.getMessage())};
                throw new SQLServerException(this, messageFormat.format(objectArray), null, 0, true);
            }
            n2 += n4;
        }
        if (this.nOutIndex + n2 > this.binDataBuffer.length) {
            this.extendByteBuffer(n2);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)n3;
        if (n3 > 0) {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 0;
            this.bufferAppendString(string);
        }
        this.binDataBuffer[this.nOutIndex++] = bl ? (byte)1 : 0;
        this.binDataBuffer[this.nOutIndex++] = -89;
        if (bl4) {
            this.bufferAppendVMaxHeader(n4, bl3, true);
            if (bl3 || 0 == n4) {
                return;
            }
            System.arraycopy(byArray, 0, this.binDataBuffer, this.nOutIndex, byArray.length);
            this.nOutIndex += byArray.length;
            this.bufferAppendInt(0);
        } else {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 31;
            this.setStringControlCharacters();
            if (bl3) {
                this.bufferAppendShort((short)-1);
            } else {
                this.bufferAppendShort((short)n4);
                if (0 == n4) {
                    return;
                }
                System.arraycopy(byArray, 0, this.binDataBuffer, this.nOutIndex, byArray.length);
                this.nOutIndex += byArray.length;
            }
        }
    }

    final void bufferAppendRPCLongStringUnicode(String string, String string2, boolean bl) {
        boolean bl2 = string == null;
        boolean bl3 = string2 == null;
        boolean bl4 = this.dbCom.getTDSVersion().isYukonOrLater();
        int n = 17;
        int n2 = 0;
        int n3 = 0;
        if (!bl2) {
            n2 = string.length() + 1;
            n += n2 * 2;
        }
        if (!bl3) {
            n3 = string2.length() * 2;
            n += n3;
        }
        if (this.nOutIndex + n > this.binDataBuffer.length) {
            this.extendByteBuffer(n);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)n2;
        if (n2 > 0) {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 0;
            this.bufferAppendString(string);
        }
        this.binDataBuffer[this.nOutIndex++] = bl ? (byte)1 : 0;
        if (bl4) {
            this.binDataBuffer[this.nOutIndex++] = -25;
            this.bufferAppendVMaxHeader(n3, bl3, true);
            if (bl3 || 0 == n3) {
                return;
            }
            this.bufferAppendString(string2);
            this.bufferAppendInt(0);
        } else {
            this.binDataBuffer[this.nOutIndex++] = 99;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = 127;
            this.setStringControlCharacters();
            if (bl3) {
                this.bufferAppendInt(-1);
            } else {
                this.bufferAppendInt(n3);
                if (0 == n3) {
                    return;
                }
                this.bufferAppendString(string2);
            }
        }
    }

    final void bufferAppendRPCInputStream(String string, InputStream inputStream, InputStreamArgs inputStreamArgs, boolean bl) throws SQLServerException {
        int n;
        boolean bl2;
        int n2;
        boolean bl3 = inputStream == null;
        boolean bl4 = string == null;
        int n3 = 32;
        int n4 = 0;
        int n5 = n2 = null == inputStream ? 0 : inputStreamArgs.length;
        boolean bl5 = 0 == inputStreamArgs.nativeType ? 3 != inputStreamArgs.streamType : (bl2 = DataTypes.isBinary(inputStreamArgs.nativeType));
        int n6 = bl2 ? (inputStreamArgs.isYukonOrLater ? 165 : 34) : (inputStreamArgs.isYukonOrLater ? 167 : 35);
        boolean bl6 = inputStreamArgs.isYukonOrLater;
        if (!bl4) {
            n4 = string.length() + 1;
            n3 += n4 * 2;
        }
        if (this.nOutIndex + n3 > this.binDataBuffer.length) {
            this.extendByteBuffer(n3);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)n4;
        if (n4 > 0) {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 0;
            this.bufferAppendString(string);
        }
        this.binDataBuffer[this.nOutIndex++] = bl ? (byte)1 : 0;
        this.binDataBuffer[this.nOutIndex++] = (byte)n6;
        if (-1 == n2 && !bl3) {
            if (bl6) {
                this.bufferAppendVMaxHeader(-1, false, !bl2);
                try {
                    while (true) {
                        int n7;
                        if ((n7 = this.maxPacketPayloadBytes() - this.nOutIndex) < 4) {
                            this.interimStreamSend();
                            n7 = this.maxPacketPayloadBytes() - this.nOutIndex;
                        }
                        int n8 = this.nOutIndex;
                        int n9 = inputStream.read(this.binDataBuffer, this.nOutIndex + 4, n7 - 4);
                        if (n9 <= 0) {
                            this.bufferAppendInt(0);
                            return;
                        }
                        this.binDataBuffer[n8++] = (byte)(n9 >> 0 & 0xFF);
                        this.binDataBuffer[n8++] = (byte)(n9 >> 8 & 0xFF);
                        this.binDataBuffer[n8++] = (byte)(n9 >> 16 & 0xFF);
                        this.binDataBuffer[n8++] = (byte)(n9 >> 24 & 0xFF);
                        this.nOutIndex += n9 + 4;
                    }
                }
                catch (IOException iOException) {
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, iOException.getMessage(), "08006", true);
                }
            } else {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8000);
                    byte[] byArray = new byte[8000];
                    n2 = 0;
                    while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                        n2 += n;
                        byteArrayOutputStream.write(byArray);
                    }
                    inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }
                catch (IOException iOException) {
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, iOException.getMessage(), "08006", true);
                }
            }
        }
        if (bl6) {
            this.bufferAppendVMaxHeader(n2, bl3, !bl2);
            if (bl3 || 0 == n2) {
                return;
            }
        } else {
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = 127;
            if (n6 == 35 || n6 == 99) {
                this.setStringControlCharacters();
            }
            if (bl3) {
                this.bufferAppendInt(-1);
                return;
            }
            this.bufferAppendInt(n2);
            if (0 == n2) {
                return;
            }
        }
        if (this.nOutIndex > this.maxPacketPayloadBytes()) {
            this.interimStreamSend();
        }
        int n10 = n2;
        int n11 = this.maxPacketPayloadBytes() - this.nOutIndex;
        while (true) {
            n = n10 > n11 ? n11 : n10;
            try {
                int n12;
                for (int i = 0; i < n; i += n12) {
                    n12 = inputStream.read(this.binDataBuffer, this.nOutIndex + i, n - i);
                    if (n12 >= 0) continue;
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_prematureEndOfBinaryStream"));
                    Object[] objectArray = new Object[]{new Integer(i), new Integer(n2)};
                    String string2 = messageFormat.format(objectArray);
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, string2, null, false);
                }
                this.nOutIndex += n;
            }
            catch (IOException iOException) {
                SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, iOException.toString(), "08006", false);
            }
            if ((n10 -= n) == 0) break;
            this.interimSend();
            n11 = this.maxPacketPayloadBytes();
        }
        if (bl6) {
            this.bufferAppendInt(0);
        }
    }

    final int maxPacketPayloadBytes() {
        return 4088 - (this.dbCom.getTDSVersion().isYukonOrLater() && !this.bFirstPacketSent ? 22 : 0);
    }

    private final void interimSend() throws SQLServerException {
        this.dbCom.aquireExclusiveUse(this);
        this.dbCom.transmit((byte)3, this, 0, 2, false);
        this.bFirstPacketSent = true;
    }

    final void interimStreamSend() throws SQLServerException {
        while (this.nOutIndex >= this.maxPacketPayloadBytes()) {
            if (tdsDiagLogger.isLoggable(Level.FINEST)) {
                this.logTDSDiag("InterimStreamSend: out buffer index:" + this.nOutIndex);
            }
            int n = this.maxPacketPayloadBytes();
            int n2 = this.nOutIndex - n;
            this.nOutIndex = n;
            this.interimSend();
            if (n2 > 0) {
                System.arraycopy(this.binDataBuffer, n, this.binDataBuffer, 0, n2);
            }
            this.nOutIndex = n2;
        }
    }

    void bufferAppendVMaxHeader(int n, boolean bl, boolean bl2) {
        int n2 = 17;
        if (this.nOutIndex + n2 > this.binDataBuffer.length) {
            this.extendByteBuffer(n2);
        }
        this.binDataBuffer[this.nOutIndex++] = -1;
        this.binDataBuffer[this.nOutIndex++] = -1;
        if (bl2) {
            this.setStringControlCharacters();
        }
        if (bl) {
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            return;
        }
        if (-1 == n) {
            this.binDataBuffer[this.nOutIndex++] = -2;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
        } else {
            this.bufferAppendInt(n);
            this.bufferAppendInt(0);
            this.bufferAppendInt(n);
        }
    }

    final void bufferAppendRPCReader(String string, Reader reader, int n, boolean bl, boolean bl2) throws SQLServerException {
        boolean bl3 = reader == null;
        boolean bl4 = string == null;
        int n2 = 32;
        int n3 = 0;
        if (!bl4) {
            n3 = string.length() + 1;
            n2 += n3 * 2;
        }
        if (this.nOutIndex + n2 > this.binDataBuffer.length) {
            this.extendByteBuffer(n2);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)n3;
        if (n3 > 0) {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 0;
            this.bufferAppendString(string);
        }
        this.binDataBuffer[this.nOutIndex++] = bl2 ? (byte)1 : 0;
        this.binDataBuffer[this.nOutIndex++] = (byte)(bl ? 231 : 99);
        if (-1 == n && !bl3) {
            Object object;
            if (bl) {
                object = new char[4000];
                this.bufferAppendVMaxHeader(-1, false, true);
                int n4 = this.maxPacketPayloadBytes();
                try {
                    block6: while (true) {
                        int n5;
                        if ((n5 = reader.ready() ? reader.read((char[])object, 0, ((Object)object).length) : -1) <= 0) {
                            this.bufferAppendInt(0);
                            return;
                        }
                        this.bufferAppendInt(n5 * 2);
                        int n6 = 0;
                        while (true) {
                            if (n6 >= n5) continue block6;
                            Object object2 = object[n6];
                            if (this.nOutIndex + 1 >= n4) {
                                this.interimStreamSend();
                                n4 = this.maxPacketPayloadBytes();
                            }
                            this.binDataBuffer[this.nOutIndex++] = (byte)(object2 & 0xFF);
                            this.binDataBuffer[this.nOutIndex++] = (byte)((object2 & 0xFF00) >> 8);
                            ++n6;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, SQLServerException.getErrString("R_unexpectedIOExceptionProcessingReader"), "08006", true);
                }
            } else {
                try {
                    object = DDC.convertReaderToString(reader, n);
                    n = ((String)object).length();
                    reader = new StringReader((String)object);
                }
                catch (SQLServerException sQLServerException) {
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, SQLServerException.getErrString("R_unexpectedIOExceptionProcessingReader"), "08006", true);
                }
            }
        }
        if (bl) {
            this.bufferAppendVMaxHeader(n * 2, bl3, true);
            if (bl3 || 0 == n) {
                return;
            }
        } else {
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = -1;
            this.binDataBuffer[this.nOutIndex++] = 127;
            this.setStringControlCharacters();
            if (bl3) {
                this.bufferAppendInt(-1);
                return;
            }
            int n7 = n * 2;
            this.bufferAppendInt(n7);
            if (0 == n7) {
                return;
            }
        }
        if (this.nOutIndex > this.maxPacketPayloadBytes()) {
            this.interimStreamSend();
        }
        int n8 = n * 2;
        int n9 = this.maxPacketPayloadBytes();
        for (int i = 0; i < n; ++i) {
            try {
                int n10 = reader.read();
                if (n10 == -1) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_prematureEndOfCharacterStream"));
                    Object[] objectArray = new Object[]{new Integer(i), new Integer(n)};
                    String string2 = messageFormat.format(objectArray);
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, string2, "08006", false);
                }
                if (this.nOutIndex + 1 >= n9) {
                    this.interimStreamSend();
                    n9 = this.maxPacketPayloadBytes();
                }
                this.binDataBuffer[this.nOutIndex++] = (byte)(n10 & 0xFF);
                this.binDataBuffer[this.nOutIndex++] = (byte)((n10 & 0xFF00) >> 8);
                continue;
            }
            catch (IOException iOException) {
                SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, SQLServerException.getErrString("R_unexpectedIOExceptionProcessingReader"), "08006", true);
            }
        }
        if (bl) {
            this.bufferAppendInt(0);
        }
    }

    final void bufferAppendRPCDouble(String string, Double d, boolean bl) {
        boolean bl2 = string == null;
        int n = 16;
        int n2 = 0;
        boolean bl3 = false;
        if (!bl2) {
            n2 = string.length() + 1;
            n += n2 * 2;
        }
        if (this.nOutIndex + n > this.binDataBuffer.length) {
            this.extendByteBuffer(n);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)n2;
        if (n2 > 0) {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 0;
            this.bufferAppendString(string);
        }
        this.binDataBuffer[this.nOutIndex++] = bl ? (byte)1 : 0;
        this.binDataBuffer[this.nOutIndex++] = 109;
        int n3 = 8;
        this.binDataBuffer[this.nOutIndex++] = (byte)n3;
        if (null == d) {
            this.binDataBuffer[this.nOutIndex++] = 0;
        } else {
            this.binDataBuffer[this.nOutIndex++] = (byte)n3;
            long l = Double.doubleToLongBits(d);
            long l2 = 255L;
            int n4 = 0;
            for (int i = 0; i < 8; ++i) {
                this.binDataBuffer[this.nOutIndex++] = (byte)((l & l2) >> n4);
                n4 += 8;
                l2 <<= 8;
            }
        }
    }

    final void bufferAppendRPCReal(String string, Float f, boolean bl) {
        this.bufferAppendRPCNameValType(string, bl, 109);
        int n = 4;
        this.binDataBuffer[this.nOutIndex++] = (byte)n;
        if (null == f) {
            this.binDataBuffer[this.nOutIndex++] = 0;
        } else {
            this.binDataBuffer[this.nOutIndex++] = (byte)n;
            int n2 = Float.floatToIntBits(f.floatValue());
            int n3 = 255;
            int n4 = 0;
            for (int i = 0; i < 4; ++i) {
                this.binDataBuffer[this.nOutIndex++] = (byte)((n2 & n3) >> n4);
                n4 += 8;
                n3 <<= 8;
            }
        }
    }

    final void bufferAppendRPCByteArray(String string, byte[] byArray, boolean bl, int n) {
        boolean bl2 = string == null;
        boolean bl3 = byArray == null;
        boolean bl4 = false;
        if (!bl3 && byArray.length > 8000) {
            bl4 = true;
        }
        boolean bl5 = this.dbCom.getTDSVersion().isYukonOrLater() && -2 != n && (bl4 || bl);
        int n2 = 30;
        int n3 = 0;
        int n4 = 0;
        if (!bl2) {
            n3 = string.length() + 1;
            n2 += n3 * 2;
        }
        if (!bl3) {
            n4 = byArray.length;
            n2 += n4;
        }
        if (this.nOutIndex + n2 > this.binDataBuffer.length) {
            this.extendByteBuffer(n2);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)n3;
        if (n3 > 0) {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 0;
            this.bufferAppendString(string);
        }
        this.binDataBuffer[this.nOutIndex++] = bl ? (byte)1 : 0;
        if (bl5) {
            this.binDataBuffer[this.nOutIndex++] = -91;
            this.bufferAppendVMaxHeader(n4, bl3, false);
            if (bl3) {
                return;
            }
            System.arraycopy(byArray, 0, this.binDataBuffer, this.nOutIndex, n4);
            this.nOutIndex += n4;
            this.bufferAppendInt(0);
        } else {
            if (bl4) {
                this.binDataBuffer[this.nOutIndex++] = 34;
                this.binDataBuffer[this.nOutIndex++] = -1;
                this.binDataBuffer[this.nOutIndex++] = -1;
                this.binDataBuffer[this.nOutIndex++] = -1;
                this.binDataBuffer[this.nOutIndex++] = 127;
            } else {
                this.binDataBuffer[this.nOutIndex++] = -91;
                this.bufferAppendShort((short)8000);
            }
            if (bl3) {
                this.bufferAppendShort((short)-1);
            } else {
                if (bl4) {
                    this.bufferAppendInt(n4);
                } else {
                    this.bufferAppendShort((short)n4);
                }
                if (0 == n4) {
                    return;
                }
                System.arraycopy(byArray, 0, this.binDataBuffer, this.nOutIndex, n4);
                this.nOutIndex += n4;
            }
        }
    }

    final void bufferAppendRPCBigDecimal(String string, BigDecimal bigDecimal, int n, boolean bl) {
        boolean bl2;
        int n2;
        boolean bl3 = string == null;
        int n3 = 12;
        int n4 = 0;
        boolean bl4 = false;
        byte[] byArray = null;
        if (bigDecimal == null) {
            n2 = 0;
            bl2 = false;
        } else {
            BigInteger bigInteger;
            bl2 = bigDecimal.signum() < 0;
            BigInteger bigInteger2 = bigInteger = bigDecimal.scale() < 0 ? bigDecimal.setScale(0).unscaledValue() : bigDecimal.unscaledValue();
            if (bl2) {
                bigInteger = bigInteger.negate();
            }
            byArray = bigInteger.toByteArray();
            n2 = byArray.length;
            n3 += n2;
        }
        if (!bl3) {
            n4 = string.length() + 1;
            n3 += n4 * 2;
        }
        if (this.nOutIndex + n3 > this.binDataBuffer.length) {
            this.extendByteBuffer(n3);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)n4;
        if (n4 > 0) {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 0;
            this.bufferAppendString(string);
        }
        this.binDataBuffer[this.nOutIndex++] = bl ? (byte)1 : 0;
        this.binDataBuffer[this.nOutIndex++] = 106;
        this.binDataBuffer[this.nOutIndex++] = 17;
        this.binDataBuffer[this.nOutIndex++] = 38;
        if (bigDecimal == null) {
            this.binDataBuffer[this.nOutIndex++] = (byte)n;
            this.binDataBuffer[this.nOutIndex++] = 0;
            return;
        }
        byte by = (byte)(bigDecimal.scale() < 0 ? 0 : bigDecimal.scale());
        this.binDataBuffer[this.nOutIndex++] = by;
        this.binDataBuffer[this.nOutIndex++] = (byte)(n2 + 1);
        this.binDataBuffer[this.nOutIndex++] = bl2 ? (byte)0 : 1;
        for (int i = n2 - 1; i >= 0; --i) {
            this.binDataBuffer[this.nOutIndex++] = byArray[i];
        }
    }

    final void bufferAppendRPCTimestamp(String string, Timestamp timestamp, Calendar calendar, boolean bl) {
        boolean bl2 = string == null;
        int n = 50;
        int n2 = 0;
        boolean bl3 = false;
        if (!bl2) {
            n2 = string.length() + 1;
            n += n2 * 2;
        }
        if (this.nOutIndex + n > this.binDataBuffer.length) {
            this.extendByteBuffer(n);
        }
        this.binDataBuffer[this.nOutIndex++] = (byte)n2;
        if (n2 > 0) {
            this.binDataBuffer[this.nOutIndex++] = 64;
            this.binDataBuffer[this.nOutIndex++] = 0;
            this.bufferAppendString(string);
        }
        this.binDataBuffer[this.nOutIndex++] = bl ? (byte)1 : 0;
        this.binDataBuffer[this.nOutIndex++] = 111;
        this.binDataBuffer[this.nOutIndex++] = 8;
        if (null == timestamp) {
            this.binDataBuffer[this.nOutIndex++] = 0;
        } else {
            this.binDataBuffer[this.nOutIndex++] = 8;
            Util.timestampToBytes(timestamp.getTime(), calendar, this.binDataBuffer, this.nOutIndex);
            this.nOutIndex += 8;
        }
    }

    private void logTDSDiag(String string) {
        tdsDiagLogger.finest(this.instanceId() + string.toString());
    }
}

