/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.IOBuffer;
import com.microsoft.sqlserver.jdbc.JDBCCallSyntaxTranslator;
import com.microsoft.sqlserver.jdbc.PacketRequestor;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerParameterMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.StreamColumns;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import com.microsoft.sqlserver.jdbc.TDSVersion;
import com.microsoft.sqlserver.jdbc.Util;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLServerStatement
extends IOBuffer
implements Statement {
    static final char LEFT_CURLY_BRACKET = '{';
    static final char RIGHT_CURLY_BRACKET = '}';
    final boolean isInternal;
    static final String identityQuery = " select SCOPE_IDENTITY()";
    String userSQL;
    String procedureName;
    TDSVersion tdsVersion;
    PacketRequestor[] packetRequestor;
    int prepStmtHandle = 0;
    Parameter[] inOutParam;
    SQLServerConnection connection;
    int queryTimeout;
    SQLServerResultSet resultSet;
    private ResultSetMetaData metaResults;
    boolean bOnlyResultSets;
    int updateCount;
    boolean escapeProcessing;
    int maxRows;
    int resultSetConcurrency;
    int appResultSetType;
    int resultSetType;
    int nCursorId;
    private int serverCursorRowCount;
    boolean isServerSideCursor;
    boolean isDynamicCursor = false;
    String cursorName;
    int nFetchSize;
    int defaultFetchSize;
    private boolean bHasRows;
    static final int FETCH_FIRST = 1;
    static final int FETCH_NEXT = 2;
    static final int FETCH_PREV = 4;
    static final int FETCH_LAST = 8;
    static final int FETCH_ABSOLUTE = 16;
    static final int FETCH_RELATIVE = 32;
    static final int FETCH_REFRESH = 128;
    static final int FETCH_INFO = 256;
    static final int FETCH_PREV_NOADJUST = 512;
    static final int STMT_TYPE_STMT = 0;
    static final int STMT_TYPE_PREPARED = 1;
    static final int STMT_TYPE_CALLEDPROC = 2;
    int nStatementType;
    Column[] columns;
    boolean bOutParamsGot;
    int nFetchDirection;
    boolean bIsClosed;
    private int nStartRowOffset;
    private int nSkippedRows;
    static int nLastID;
    int nID;
    boolean bRequestedGeneratedKeys;
    private ResultSet autoGeneratedKeys;
    String sCursorCommand;
    private String sCursorTable;
    private static boolean bCp1252;
    private final int ROWSET_INDEX_INCR = 4096;
    private char[] cGetCharBuffer;
    boolean sendStringParametersAsUnicode = true;
    private SQLServerStatement nextResultSetParentStmt;
    private boolean lastUpdateCount;
    StringBuffer batchStatementBuffer;
    int batchSize;
    ArrayList batchParameters;
    HashMap invalidBatchStmts;
    private Logger stmtlogger;
    static final int SCROLLOPT_KEYSET = 1;
    static final int SCROLLOPT_DYNAMIC = 2;
    static final int SCROLLOPT_FORWARD_ONLY = 4;
    static final int SCROLLOPT_STATIC = 8;
    static final int SCROLLOPT_FAST_FORWARD = 16;
    static final int SCROLLOPT_PARAMETERIZED_STMT = 4096;
    static final int SCROLLOPT_AUTO_FETCH = 8192;
    static final int SCROLLOPT_AUTO_CLOSE = 16384;
    static final int CCOPT_READ_ONLY = 1;
    static final int CCOPT_SCROLL_LOCKS = 2;
    static final int CCOPT_OPTIMISTIC_CC = 4;
    static final int CCOPT_OPTIMISTIC_CCVAL = 8;
    static final int CCOPT_ALLOW_DIRECT = 8192;
    static final int CCOPT_UPDT_IN_PLACE = 16384;

    final int getSQLResultSetType() {
        return this.resultSetType;
    }

    final boolean hasRowsInFetchBuffer() {
        return this.bHasRows;
    }

    SQLServerStatement() {
        super(null, 1);
        this.nStatementType = 0;
        this.isServerSideCursor = false;
        this.isInternal = true;
        this.stmtlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerStatement");
    }

    SQLServerStatement(SQLServerConnection sQLServerConnection, boolean bl, int n, int n2, boolean bl2) throws SQLServerException {
        super(sQLServerConnection.getDbCom(), 4096);
        this.nID = nLastID++;
        this.connection = sQLServerConnection;
        this.tdsVersion = sQLServerConnection.getDbCom().getTDSVersion();
        this.bIsClosed = false;
        bCp1252 = Util.bCp1252;
        this.lastUpdateCount = bl2;
        this.packetRequestor = new PacketRequestor[5];
        for (int i = 0; i < 5; ++i) {
            this.packetRequestor[i] = new PacketRequestor();
        }
        this.invalidBatchStmts = new HashMap();
        this.isInternal = bl;
        if (bl) {
            this.appResultSetType = 1004;
            this.resultSetConcurrency = 1007;
            this.isServerSideCursor = false;
            this.resultSetType = -1;
        } else {
            String string;
            if (1003 != n && 1005 != n && 1004 != n && 2003 != n && 2004 != n && 1006 != n && 1005 != n && 1004 != n) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedCursor"), null, true);
            }
            if (1007 != n2 && 1008 != n2 && 1009 != n2 && 1008 != n2 && 1010 != n2) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedConcurrency"), null, true);
            }
            this.resultSetConcurrency = n2;
            this.appResultSetType = n;
            this.resultSetType = 1003 == n ? (1007 == n2 ? (null == (string = sQLServerConnection.getSelectMethod()) || !string.equals("cursor") ? 2003 : 2004) : 2004) : (1004 == n ? 1004 : (1005 == n ? 1005 : n));
            this.nFetchDirection = 2003 == this.resultSetType || 2004 == this.resultSetType ? 1000 : 1002;
            this.defaultFetchSize = this.nFetchSize = 1009 == this.resultSetConcurrency ? 8 : 128;
            if (1007 != n2 && (2003 == this.resultSetType || 1004 == this.resultSetType)) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedCursorAndConcurrency"), null, true);
            }
            this.isServerSideCursor = this.resultSetType != 2003;
        }
        this.stmtlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerStatement");
        if (this.stmtlogger.isLoggable(Level.FINE)) {
            String string = "Statement properties  ID:" + this.nID;
            string = null != this.connection ? string + " Connection:" + this.connection.connectionID : string + " Connection:" + "null";
            string = string + " Result type:" + this.appResultSetType + " (" + this.resultSetType + ")" + " Concurrency:" + this.resultSetConcurrency + " Fetchsize:" + this.nFetchSize + " bIsClosed:" + this.bIsClosed + " tdsVersion:" + this.tdsVersion + " bCp1252:" + bCp1252 + " lastUpdateCount:" + bl2 + " isServerSideCursor:" + this.isServerSideCursor;
            this.stmtlogger.fine(string);
        }
    }

    byte indexRow() throws SQLServerException {
        byte by;
        int n = this.nStartRowOffset;
        if (n >= this.nRecvSize) {
            return -3;
        }
        if ((by = this.binDataBuffer[n++]) != -47) {
            return by;
        }
        int n2 = this.columns.length;
        for (int i = 0; i < n2; ++i) {
            n = this.columns[i].setFromTDS(this.columns[i].getTypeInfo(), n, this.binDataBuffer);
        }
        this.nStartRowOffset = n;
        return -47;
    }

    final void fetchBufferBeforeFirst() {
        this.nStartRowOffset = this.nInIndex;
    }

    final boolean fetchBufferNext() throws SQLServerException {
        byte by = this.indexRow();
        if (by != -47) {
            if (by == -86) {
                this.movePastResultSet();
                this.packetRequestor[0].setType((byte)-86);
                StreamPacket streamPacket = this.processPackets(this.connection, this.packetRequestor, 1, "EndOfResultSet", true);
            }
            return false;
        }
        return true;
    }

    final int countRowsInFetchBuffer() throws SQLServerException {
        int n = this.nStartRowOffset;
        this.nStartRowOffset = this.nInIndex;
        int n2 = 0;
        while (this.indexRow() == -47) {
            ++n2;
        }
        this.nStartRowOffset = n;
        return n2;
    }

    final void checkColumnConvertsFromJDBCType(int n, int n2) throws SQLServerException {
        int n3 = this.columns[n - 1].getTypeInfo().getNativeType();
        if (!DataTypes.canConvertToNativeTypeFromJDBCType(n3, this.columns[n - 1].getTypeInfo().getMaxLength(), n2)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(n2), DataTypes.sqlNativeTypeToString(n3)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
    }

    final int getColumnCount() {
        if (null == this.columns) {
            return 0;
        }
        int n = this.columns.length;
        if (this.isServerSideCursor) {
            --n;
        }
        return n;
    }

    final Column getColumn(int n) {
        return this.columns[n - 1];
    }

    final void buildNextRowset() throws SQLServerException {
        Object var1_1 = null;
        boolean bl = false;
        this.clearWarnings();
        int n = 0;
        this.packetRequestor[n++].setType((byte)-47, false);
        this.packetRequestor[n++].setType((byte)-3, false);
        this.packetRequestor[n++].setType((byte)-2, false);
        PacketRequestor packetRequestor = this.packetRequestor[n++];
        packetRequestor.setType((byte)-1, false);
        packetRequestor.bDONEINPROCUnconditional = true;
        StreamPacket streamPacket = this.processPackets(this.connection, this.packetRequestor, n, "buildNextRowset", false);
        packetRequestor.bDONEINPROCUnconditional = false;
        this.initRowset(this.packetRequestor[0].bFound);
    }

    private final void initRowset(boolean bl) throws SQLServerException {
        this.nStartRowOffset = this.nInIndex;
        if (!this.isServerSideCursor) {
            this.bHasRows = bl;
        }
    }

    final void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    public void close() throws SQLServerException {
        if (this.bIsClosed) {
            return;
        }
        this.detachRS();
        this.metaResults = null;
        this.columns = null;
        this.bIsClosed = true;
        this.inOutParam = null;
        this.binDataBuffer = null;
    }

    private String ensureSQLSyntax(String string) {
        if (string.indexOf(123) >= 0) {
            JDBCCallSyntaxTranslator jDBCCallSyntaxTranslator = new JDBCCallSyntaxTranslator();
            String string2 = jDBCCallSyntaxTranslator.translate(string);
            this.procedureName = jDBCCallSyntaxTranslator.getProcedureName();
            return string2;
        }
        return string;
    }

    public ResultSet executeQuery(String string) throws SQLServerException {
        SQLServerResultSet sQLServerResultSet;
        this.checkClosed();
        boolean bl = this.stmtlogger.isLoggable(Level.FINE);
        this.initializeQuery();
        this.userSQL = string = this.ensureSQLSyntax(string);
        if (this.isServerSideCursor) {
            if (bl) {
                this.stmtlogger.fine("Executing server side cursor " + string);
            }
            this.cursorOpen(string);
            sQLServerResultSet = this.resultSet;
        } else {
            SQLServerResultSet sQLServerResultSet2;
            this.cbufferAppendString(string);
            if (bl) {
                this.stmtlogger.fine("Executing (not server cursor) " + string);
            }
            sQLServerResultSet = sQLServerResultSet2 = this.doExecuteQuery((byte)1);
        }
        return sQLServerResultSet;
    }

    void initializeQuery() throws SQLServerException {
        this.userSQL = null;
        this.columns = null;
        this.detachRS();
    }

    final SQLServerResultSet doExecuteQuery(byte by) throws SQLServerException {
        this.bOnlyResultSets = true;
        this.sendExecute(by, false);
        if (this.resultSet == null) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_noResultset"), null, true);
        }
        return this.resultSet;
    }

    final void detachRS() throws SQLServerException {
        if (null != this.resultSet) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.autoGeneratedKeys = null;
    }

    public int executeUpdate(String string) throws SQLServerException {
        this.checkClosed();
        this.initializeQuery();
        string = this.ensureSQLSyntax(string);
        if (string != null) {
            this.cbufferAppendString(string);
        }
        return this.doExecuteUpdate((byte)1);
    }

    final int doExecuteUpdate(byte by) throws SQLServerException {
        this.checkClosed();
        this.bOnlyResultSets = false;
        if (this.bRequestedGeneratedKeys && 3 != by) {
            this.cbufferAppendString(identityQuery);
        }
        this.sendExecute(by, true);
        if (this.resultSet != null) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
        }
        int n = this.getUpdateCount();
        return n;
    }

    final boolean isSelect(String string) throws SQLServerException {
        this.checkClosed();
        String string2 = string.trim();
        char c = string2.charAt(0);
        if (c != 's' && c != 'S') {
            return false;
        }
        return string2.substring(0, 6).equalsIgnoreCase("select");
    }

    private HashMap parseColumns(String string) throws SQLServerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl3;
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf("(") >= 0 && !bl) {
                bl = true;
                bl3 = SQLServerStatement.checkBalancedParenthesis(string3);
                if (!bl3) {
                    string2 = string2 + string3;
                }
                if (!bl3) continue;
                hashMap.put(new Integer(n++), string3);
                continue;
            }
            if (bl) {
                bl3 = SQLServerStatement.checkBalancedParenthesis(string2 = string2 + string3);
                if (!bl3) continue;
                bl = false;
                hashMap.put(new Integer(n++), string2);
                string2 = "";
                continue;
            }
            hashMap.put(new Integer(n++), string3);
        }
        if (bl) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_errorProcessingComplexQuery"), null, true);
        }
        return hashMap;
    }

    private static boolean checkBalancedParenthesis(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n = string.indexOf("(", n + 1)) != -1) {
            ++n3;
        }
        while ((n2 = string.indexOf(")", n2 + 1)) != -1) {
            ++n4;
        }
        return n3 == n4;
    }

    static String replaceParameterWithString(String string, char c, String string2) {
        int n = 0;
        while ((n = string.indexOf("" + c)) >= 0) {
            string = string.substring(0, n) + string2 + string.substring(n + 1, string.length());
        }
        return string;
    }

    static String replaceMarkerWithNull(String string) {
        if (string.indexOf("'") < 0) {
            String string2 = SQLServerStatement.replaceParameterWithString(string, '?', "null");
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "'", true);
        boolean bl = true;
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("'")) {
                string3 = string3 + "'";
                bl = !bl;
                continue;
            }
            if (bl) {
                String string5 = SQLServerStatement.replaceParameterWithString(string4, '?', "null");
                string3 = string3 + string5;
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    public boolean execute(String string) throws SQLServerException {
        this.checkClosed();
        this.initializeQuery();
        this.userSQL = string = this.ensureSQLSyntax(string);
        if (this.isServerSideCursor && this.isSelect(string)) {
            this.executeQuery(string);
            return true;
        }
        this.cbufferAppendString(string);
        boolean bl = this.doExecute((byte)1);
        return bl;
    }

    final boolean doExecute(byte by) throws SQLServerException {
        this.checkClosed();
        this.bOnlyResultSets = false;
        if (this.bRequestedGeneratedKeys && 3 != by) {
            this.cbufferAppendString(identityQuery);
        }
        boolean bl = this.sendExecute(by, false);
        return bl;
    }

    void checkClosed() throws SQLServerException {
        if (this.bIsClosed) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementIsClosed"), null, false);
        }
        this.connection.checkClosed();
    }

    final boolean sendExecute(byte by, boolean bl) throws SQLServerException {
        if (this.bIsClosed) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementIsClosed"), null, false);
        }
        if (!this.connection.bIsOpen) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
        this.columns = null;
        this.bOutParamsGot = false;
        this.nLastRetStatIndex = -1;
        if (this.nCursorId != 0) {
            this.closeServerCursor();
        }
        this.resultSet = null;
        if (this.maxRows > 0) {
            if (3 == by) {
                this.setRowCount(this.maxRows);
            } else {
                this.cbufferInsertString("SET ROWCOUNT " + this.maxRows + "\n");
                this.cbufferAppendString("\nSET ROWCOUNT 0");
            }
        }
        this.sendCommand(by, this.queryTimeout, false);
        if (this.maxRows > 0 && 3 == by) {
            this.setRowCount(0);
        }
        if (!this.isInternal && 3 == by) {
            this.packetRequestor[0].setType((byte)-84);
            this.packetRequestor[1].setType((byte)-127);
            StreamPacket streamPacket = this.processPackets(this.connection, this.packetRequestor, 2, "sp_*exec", true);
            if (null != this.sqlWarnings && this.sqlWarnings.size() > 0 && 16954 == ((SQLWarning)this.sqlWarnings.firstElement()).getErrorCode()) {
                this.isServerSideCursor = false;
            }
            if (this.isServerSideCursor && streamPacket instanceof StreamColumns) {
                Object[] objectArray;
                MessageFormat messageFormat;
                if (0 == this.prepStmtHandle) {
                    streamPacket = this.processPackets(this.connection, this.packetRequestor, 1, "", true);
                    if (!(streamPacket instanceof StreamRetValue)) {
                        SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_cantRetrieveHandle"), null, true);
                    }
                    this.prepStmtHandle = ((StreamRetValue)streamPacket).getParam().getInt();
                }
                if (!((streamPacket = this.processPackets(this.connection, this.packetRequestor, 1, "", true)) instanceof StreamRetValue)) {
                    messageFormat = new MessageFormat(SQLServerException.getErrString("R_exhaustedInput"));
                    objectArray = new Object[]{"StreamRetValue (cursor ID)"};
                    SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
                }
                this.nCursorId = ((StreamRetValue)streamPacket).getParam().getInt();
                streamPacket = this.processPackets(this.connection, this.packetRequestor, 1, "", true);
                if (!(streamPacket instanceof StreamRetValue)) {
                    messageFormat = new MessageFormat(SQLServerException.getErrString("R_exhaustedInput"));
                    objectArray = new Object[]{"StreamRetValue (row count)"};
                    SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
                }
                this.serverCursorRowCount = ((StreamRetValue)streamPacket).getParam().getInt();
                this.isDynamicCursor = -1 == this.serverCursorRowCount;
            }
            this.nInIndex = 0;
        }
        return this.getNextResult();
    }

    public final int getMaxFieldSize() throws SQLServerException {
        this.checkClosed();
        SQLServerStatement sQLServerStatement = this.connection.createInternalStatement();
        SQLServerResultSet sQLServerResultSet = (SQLServerResultSet)sQLServerStatement.executeQuery("select @@TEXTSIZE");
        sQLServerResultSet.next();
        int n = sQLServerResultSet.getInt(1);
        sQLServerResultSet.close();
        sQLServerStatement.close();
        return n;
    }

    public final void setMaxFieldSize(int n) throws SQLServerException {
        Object object;
        this.checkClosed();
        if (n < 0) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, ((Format)object).format(objectArray), null, true);
        }
        if (0 == n) {
            n = Integer.MAX_VALUE;
        }
        object = this.connection.createInternalStatement();
        ((SQLServerStatement)object).executeUpdate("set TEXTSIZE  " + n);
        ((SQLServerStatement)object).close();
    }

    public final int getMaxRows() throws SQLServerException {
        this.checkClosed();
        return this.maxRows;
    }

    public final void setMaxRows(int n) throws SQLServerException {
        this.checkClosed();
        if (n < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidRowcount"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        this.maxRows = n;
    }

    public final void setEscapeProcessing(boolean bl) throws SQLServerException {
        this.checkClosed();
        this.escapeProcessing = bl;
    }

    public final int getQueryTimeout() throws SQLServerException {
        this.checkClosed();
        return this.queryTimeout;
    }

    public final void setQueryTimeout(int n) throws SQLServerException {
        this.checkClosed();
        if (n < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidQueryTimeOutValue"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        this.queryTimeout = n;
    }

    public final void cancel() throws SQLServerException {
        this.checkClosed();
        this.getDbCom().transmit((byte)6, this, 0, 0, false);
    }

    public final SQLWarning getWarnings() throws SQLServerException {
        this.checkClosed();
        if (this.sqlWarnings == null) {
            return null;
        }
        return (SQLWarning)this.sqlWarnings.elementAt(0);
    }

    public final void clearWarnings() throws SQLServerException {
        this.checkClosed();
        this.sqlWarnings = null;
    }

    public final void setCursorName(String string) throws SQLServerException {
        this.checkClosed();
        this.cursorName = string;
    }

    final String getCursorName() {
        return this.cursorName;
    }

    public final ResultSet getResultSet() throws SQLServerException {
        this.checkClosed();
        if (this.nextResultSetParentStmt == null) {
            return this.resultSet;
        }
        return this.nextResultSetParentStmt.resultSet;
    }

    public final int getUpdateCount() throws SQLServerException {
        this.checkClosed();
        return this.updateCount;
    }

    final void movePastResultSet() throws SQLServerException {
        while (-47 == this.indexRow()) {
        }
        this.nInIndex = this.nStartRowOffset;
    }

    final void seekToOutParams() throws SQLServerException {
        if (this.nLastRetStatIndex < 0) {
            int n;
            boolean bl;
            this.movePastResultSet();
            while ((bl = this.getMoreResults()) || (n = this.getUpdateCount()) != -1) {
            }
        }
        if (this.nLastRetStatIndex < 0) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_noTDSRETSTATUS"), null, true);
        }
        this.nInIndex = this.nLastRetStatIndex;
    }

    public final boolean getMoreResults() throws SQLServerException {
        this.checkClosed();
        if (this.pastEndBuffer()) {
            this.updateCount = -1;
            return false;
        }
        return this.getNextResult();
    }

    final boolean getNextResult() throws SQLServerException {
        if (null != this.resultSet) {
            this.movePastResultSet();
        }
        int n = 0;
        if (!this.bOnlyResultSets) {
            this.packetRequestor[n++].setType((byte)-1);
            this.packetRequestor[n++].setType((byte)-3);
        }
        if (this.nStatementType == 2) {
            this.packetRequestor[n++].setType((byte)-2);
        }
        this.packetRequestor[n++].setType((byte)-127);
        this.resultSet = null;
        this.updateCount = -1;
        this.nLastRetStatIndex = -1;
        int n2 = this.nInIndex;
        do {
            StreamPacket streamPacket;
            if (null == (streamPacket = this.processPackets(this.connection, this.packetRequestor, n, "GetNextResults", true))) {
                if (!this.pastEndBuffer()) continue;
                this.nInIndex = n2;
                return false;
            }
            if (streamPacket instanceof StreamColumns) {
                this.columns = ((StreamColumns)streamPacket).columns;
                this.resultSet = new SQLServerResultSet(this);
                this.buildNextRowset();
                continue;
            }
            if (streamPacket instanceof StreamDone) {
                StreamDone streamDone = (StreamDone)streamPacket;
                if (193 == streamDone.getCurCmd() || 224 == streamDone.getCurCmd() || this.lastUpdateCount && -3 != streamDone.getPacketType() && null == this.procedureName && 2 != this.nStatementType && 1 != this.nStatementType) continue;
                this.updateCount = streamDone.hasCount() ? streamDone.getRowCount() : 0;
                continue;
            }
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_cantProcessColumnDescription"), null, true);
        } while (null == this.resultSet && -1 == this.updateCount);
        return null != this.resultSet;
    }

    public final void setFetchDirection(int n) throws SQLServerException {
        this.checkClosed();
        if (1000 != n && 1001 != n && 1002 != n || 1000 != n && (2003 == this.resultSetType || 2004 == this.resultSetType)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidFetchDirection"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
        this.nFetchDirection = n;
    }

    public final int getFetchDirection() throws SQLServerException {
        this.checkClosed();
        return this.nFetchDirection;
    }

    public final void setFetchSize(int n) throws SQLServerException {
        this.checkClosed();
        if (n < 0) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidFetchSize"), null, false);
        }
        this.nFetchSize = 0 == n ? this.defaultFetchSize : n;
    }

    public final int getFetchSize() throws SQLServerException {
        this.checkClosed();
        return this.nFetchSize;
    }

    public final int getResultSetConcurrency() throws SQLServerException {
        this.checkClosed();
        return this.resultSetConcurrency;
    }

    public final int getResultSetType() throws SQLServerException {
        this.checkClosed();
        return this.appResultSetType;
    }

    public void addBatch(String string) throws SQLServerException {
        this.checkClosed();
        boolean bl = this.isSelect(string);
        if (this.batchStatementBuffer == null) {
            this.batchStatementBuffer = new StringBuffer(262144);
            if (!bl) {
                this.batchStatementBuffer.append(string);
            }
        } else if (!bl && this.batchStatementBuffer.length() == 0) {
            this.batchStatementBuffer.append(string);
        } else if (!bl) {
            this.batchStatementBuffer.append(" ; " + string);
        }
        if (bl) {
            this.invalidBatchStmts.put(new Integer(this.batchSize), "");
        }
        ++this.batchSize;
    }

    public void clearBatch() throws SQLServerException {
        this.checkClosed();
        this.batchStatementBuffer = null;
        this.batchSize = 0;
        this.invalidBatchStmts = new HashMap();
    }

    public int[] executeBatch() throws SQLServerException, BatchUpdateException {
        this.checkClosed();
        this.initializeQuery();
        if (this.batchStatementBuffer == null) {
            this.clearBatch();
            return new int[0];
        }
        int n = this.batchSize;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = -3;
        }
        try {
            nArray = this.processBatch();
        }
        catch (SQLException sQLException) {
            if (sQLException instanceof BatchUpdateException) {
                throw (BatchUpdateException)sQLException;
            }
            SQLServerException sQLServerException = (SQLServerException)sQLException;
            if (sQLServerException.getSQLSeverity() >= 20) {
                SQLServerException.makeFromDriverError(this.connection, this, sQLException.getMessage(), "", false);
            }
            throw new BatchUpdateException(sQLServerException.toString(), sQLServerException.getSQLState(), sQLServerException.getErrorCode(), nArray);
        }
        return nArray;
    }

    private int[] processBatch() throws SQLException {
        int n;
        int[] nArray = new int[this.batchSize];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -3;
        }
        n = 0;
        BatchUpdateException batchUpdateException = null;
        if (this.batchStatementBuffer.length() == 0 && this.batchSize > 0) {
            n = 1;
            batchUpdateException = new BatchUpdateException("SELECT not permitted in batch", nArray);
            this.clearBatch();
            throw batchUpdateException;
        }
        if (this.batchStatementBuffer.length() == 0) {
            this.clearBatch();
            return new int[0];
        }
        this.userSQL = this.batchStatementBuffer.toString();
        this.cbufferAppendString(this.batchStatementBuffer.toString());
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.doExecute((byte)1);
        }
        catch (SQLServerException sQLServerException) {
            bl2 = true;
            n = 1;
            batchUpdateException = new BatchUpdateException(sQLServerException.getMessage(), nArray);
            this.getNextResult();
        }
        boolean bl3 = false;
        for (int i = 0; i < this.batchSize; ++i) {
            try {
                if (this.invalidBatchStmts.containsKey(new Integer(i))) {
                    if (n != 0) continue;
                    n = 1;
                    batchUpdateException = new BatchUpdateException("SELECT not permitted in batch", nArray);
                    continue;
                }
                if (!bl3 && !bl2) {
                    nArray[i] = this.updateCount;
                    if (nArray[i] == -1) {
                        nArray[i] = -3;
                    }
                    bl3 = true;
                    continue;
                }
                if (!bl3 && bl2) {
                    bl3 = true;
                    continue;
                }
                this.getNextResult();
                nArray[i] = this.updateCount;
                if (nArray[i] != -1) continue;
                nArray[i] = -3;
                continue;
            }
            catch (SQLException sQLException) {
                nArray[i] = -3;
                if (n == 0) {
                    n = 1;
                    batchUpdateException = new BatchUpdateException(sQLException.toString(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
                }
                this.getNextResult();
            }
        }
        if (n != 0) {
            batchUpdateException = new BatchUpdateException(batchUpdateException.toString(), batchUpdateException.getSQLState(), batchUpdateException.getErrorCode(), nArray);
            this.clearBatch();
            throw batchUpdateException;
        }
        this.clearBatch();
        return nArray;
    }

    public final Connection getConnection() throws SQLServerException {
        this.checkClosed();
        return this.connection;
    }

    final int getResultSetScrollOpt() {
        int n = null == this.inOutParam ? 0 : 4096;
        switch (this.resultSetType) {
            case 2004: {
                return n | (1007 == this.resultSetConcurrency ? 16 : 4);
            }
            case 1006: {
                return n | 2;
            }
            case 1005: {
                return n | 1;
            }
            case 1004: {
                return n | 8;
            }
        }
        return 0;
    }

    final int getResultSetCCOpt() {
        switch (this.resultSetConcurrency) {
            case 1007: {
                return 1;
            }
            case 1008: {
                return 24580;
            }
            case 1009: {
                return 24578;
            }
            case 1010: {
                return 24584;
            }
        }
        return 0;
    }

    final void cursorOpen(String string) throws SQLServerException {
        this.sCursorCommand = string;
        this.sCursorTable = null;
        String string2 = "";
        boolean bl = this.stmtlogger.isLoggable(Level.FINE);
        if (this.maxRows > 0) {
            this.setRowCount(this.maxRows);
        }
        SQLServerCallableStatement sQLServerCallableStatement = this.connection.createInternalCallableStatement("{call sp_cursoropen (?,?,?,?,?)}");
        sQLServerCallableStatement.registerOutParameter(1, 4);
        sQLServerCallableStatement.setString(2, string);
        sQLServerCallableStatement.setInt(3, this.getResultSetScrollOpt());
        sQLServerCallableStatement.setInt(4, this.getResultSetCCOpt());
        sQLServerCallableStatement.registerOutParameter(5, 4);
        if (bl) {
            this.stmtlogger.fine("Execute for cursor open SQL: " + string + " Scrollability : " + this.getResultSetScrollOpt() + " Concurrency : " + this.getResultSetCCOpt());
        }
        sQLServerCallableStatement.execute();
        this.columns = sQLServerCallableStatement.columns;
        this.nCursorId = sQLServerCallableStatement.getInt(1);
        this.serverCursorRowCount = sQLServerCallableStatement.getInt(5);
        boolean bl2 = this.isDynamicCursor = -1 == this.serverCursorRowCount;
        if (bl) {
            this.stmtlogger.fine(" Cursor ID returned: " + this.nCursorId);
        }
        this.updateCount = -1;
        this.resultSet = new SQLServerResultSet(this);
        if (this.maxRows > 0) {
            this.setRowCount(0);
        }
    }

    final void doCursorFetch(int n, int n2, int n3) throws SQLServerException {
        Object object;
        if (!this.isServerSideCursor) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_notAServerCursor"), null, false);
        }
        if (this.nCursorId == 0) {
            object = new MessageFormat(SQLServerException.getErrString("R_statementHasNoCursorName"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, ((Format)object).format(objectArray), null, true);
        }
        object = this.connection.createInternalCallableStatement("{call sp_cursorfetch (?,?,?,?)}");
        ((SQLServerPreparedStatement)object).setInt(1, this.nCursorId);
        ((SQLServerPreparedStatement)object).setInt(2, n);
        ((SQLServerPreparedStatement)object).setInt(3, n2);
        ((SQLServerPreparedStatement)object).setInt(4, n3);
        if (this.queryTimeout > 0) {
            ((SQLServerStatement)object).setQueryTimeout(this.queryTimeout);
        }
        ((SQLServerPreparedStatement)object).execute();
        this.binDataBuffer = ((SQLServerCallableStatement)object).binDataBuffer;
        this.nInIndex = ((SQLServerCallableStatement)object).nInIndex;
        this.nRecvSize = ((SQLServerCallableStatement)object).nRecvSize;
        if (n3 < 0 || n2 < 0) {
            ((SQLServerStatement)object).movePastResultSet();
            ((SQLServerCallableStatement)object).packetRequestor[0].setType((byte)121, false);
            ((IOBuffer)object).processPackets(this.connection, ((SQLServerCallableStatement)object).packetRequestor, 1, "Check for before first", false);
            int n4 = Util.readInt(((SQLServerCallableStatement)object).binDataBuffer, ((SQLServerCallableStatement)object).nInIndex + 1);
            if (2 == n4) {
                ((SQLServerPreparedStatement)object).setInt(1, this.nCursorId);
                ((SQLServerPreparedStatement)object).setInt(2, 1);
                ((SQLServerPreparedStatement)object).setInt(3, 0);
                ((SQLServerPreparedStatement)object).setInt(4, 0);
                if (this.queryTimeout > 0) {
                    ((SQLServerStatement)object).setQueryTimeout(this.queryTimeout);
                }
                ((SQLServerPreparedStatement)object).execute();
                this.binDataBuffer = ((SQLServerCallableStatement)object).binDataBuffer;
                this.nInIndex = ((SQLServerCallableStatement)object).nInIndex;
                this.nRecvSize = ((SQLServerCallableStatement)object).nRecvSize;
            }
        }
        this.initRowset(false);
    }

    final int getServerCursorRowCount() {
        return this.serverCursorRowCount;
    }

    final int getServerCursorCurrentRow() throws SQLServerException {
        SQLServerCallableStatement sQLServerCallableStatement = this.connection.createInternalCallableStatement("{call sp_cursorfetch (?,?,?,?)}");
        sQLServerCallableStatement.setInt(1, this.nCursorId);
        sQLServerCallableStatement.setInt(2, 256);
        sQLServerCallableStatement.registerOutParameter(3, 4);
        sQLServerCallableStatement.registerOutParameter(4, 4);
        sQLServerCallableStatement.execute();
        return sQLServerCallableStatement.getInt(3);
    }

    final void putRowRPC(SQLServerStatement sQLServerStatement, int n, boolean bl, boolean bl2) throws SQLServerException {
        Object object;
        this.checkClosed();
        this.bufferAppendShort((short)9);
        this.bufferAppendString("sp_cursor");
        this.bufferAppendByte((byte)0);
        this.bufferAppendByte((byte)0);
        this.bufferAppendRPCInt(null, new Integer(sQLServerStatement.nCursorId), false);
        int n2 = 0;
        n2 = bl ? 4 : (bl2 ? 34 : 33);
        this.bufferAppendRPCInt(null, new Integer(n2), false);
        this.bufferAppendRPCInt(null, new Integer(n), false);
        this.bufferAppendRPCStringUnicode(null, "", false);
        if (!bl2) {
            if (!sQLServerStatement.hasUpdatedColumns()) {
                if (bl && sQLServerStatement.sCursorCommand != null && sQLServerStatement.sCursorTable == null) {
                    object = new SQLServerParameterMetaData(this, sQLServerStatement.sCursorCommand);
                    sQLServerStatement.sCursorTable = ((SQLServerParameterMetaData)object).getTableName();
                }
                if (sQLServerStatement.sCursorTable != null) {
                    object = "INSERT " + sQLServerStatement.sCursorTable + " DEFAULT VALUES";
                    this.bufferAppendRPCStringUnicode(null, (String)object, false);
                } else {
                    SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_noColumnParameterValue"), null, true);
                }
            } else {
                this.sendUpdatedColumnValuesByRPC();
            }
        }
        this.sendCommand((byte)3, this.queryTimeout, false);
        this.packetRequestor[0].setType((byte)-2);
        object = this.processPackets(this.connection, this.packetRequestor, 1, "putRow", false);
    }

    final void sendUpdatedColumnValuesByRPC() throws SQLServerException {
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            this.columns[i].sendByRPC(this, i);
        }
    }

    final void closeServerCursor() throws SQLServerException {
        if (this.nCursorId == 0) {
            return;
        }
        if (this.connection.isClosed()) {
            return;
        }
        this.cbufferAppendString("sp_cursorclose " + this.nCursorId);
        this.sendCommand((byte)1, this.queryTimeout, false);
        this.packetRequestor[0].setType((byte)-2);
        StreamPacket streamPacket = this.processPackets(this.connection, this.packetRequestor, 1, "closeCursor", false);
        this.nCursorId = 0;
    }

    final void setRowCount(int n) throws SQLServerException {
        if (this.stmtlogger.isLoggable(Level.FINE)) {
            this.stmtlogger.fine("Set row count " + n);
        }
        SQLServerStatement sQLServerStatement = this.connection.createInternalStatement();
        sQLServerStatement.execute("SET ROWCOUNT " + n);
    }

    public final int getResultSetHoldability() throws SQLServerException {
        this.checkClosed();
        return this.connection.getHoldability();
    }

    public final boolean execute(String string, int n) throws SQLServerException {
        this.checkClosed();
        this.detachRS();
        if (n == 2) {
            return this.execute(string);
        }
        this.bRequestedGeneratedKeys = true;
        return this.execute(string);
    }

    public final boolean execute(String string, int[] nArray) throws SQLServerException {
        this.checkClosed();
        this.detachRS();
        boolean bl = false;
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        this.bRequestedGeneratedKeys = true;
        bl = this.execute(string);
        this.bRequestedGeneratedKeys = false;
        return bl;
    }

    public final boolean execute(String string, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        this.detachRS();
        boolean bl = false;
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        this.bRequestedGeneratedKeys = true;
        bl = this.execute(string);
        this.bRequestedGeneratedKeys = false;
        return bl;
    }

    public final int executeUpdate(String string, int n) throws SQLServerException {
        this.checkClosed();
        this.detachRS();
        this.bRequestedGeneratedKeys = n == 1;
        int n2 = this.executeUpdate(string);
        this.bRequestedGeneratedKeys = false;
        return n2;
    }

    public final int executeUpdate(String string, int[] nArray) throws SQLServerException {
        this.checkClosed();
        this.detachRS();
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        this.bRequestedGeneratedKeys = nArray != null;
        int n = this.executeUpdate(string);
        this.bRequestedGeneratedKeys = false;
        return n;
    }

    public final int executeUpdate(String string, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        this.detachRS();
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        this.bRequestedGeneratedKeys = stringArray != null;
        int n = this.executeUpdate(string);
        this.bRequestedGeneratedKeys = false;
        return n;
    }

    public final ResultSet getGeneratedKeys() throws SQLServerException {
        this.checkClosed();
        if (null == this.autoGeneratedKeys) {
            int n = this.nInIndex;
            int n2 = this.updateCount;
            boolean bl = this.getNextResult();
            if (bl) {
                this.autoGeneratedKeys = this.getResultSet();
            }
            this.updateCount = n2;
            if (!bl || null == this.autoGeneratedKeys) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementMustBeExecuted"), null, false);
            }
        }
        return this.autoGeneratedKeys;
    }

    public final boolean getMoreResults(int n) throws SQLServerException {
        if (2 == n) {
            this.NotImplemented();
        }
        if (1 != n && 3 != n) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_modeSuppliedNotValid"), null, true);
        }
        this.checkClosed();
        SQLServerResultSet sQLServerResultSet = this.resultSet;
        boolean bl = this.getMoreResults();
        if (sQLServerResultSet != null) {
            try {
                sQLServerResultSet.close();
            }
            catch (SQLException sQLException) {
                throw new SQLServerException(null, sQLException.getMessage(), null, 0, false);
            }
        }
        return bl;
    }

    final void clearColumnsValues() {
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            this.columns[i].cancelUpdates();
        }
    }

    final boolean hasUpdatedColumns() {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].hasUpdates()) continue;
            return true;
        }
        return false;
    }
}

