/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Util {
    static final long baseDiffDays = 25567L;
    static final long secsinday = 86400L;
    static boolean bCp1252;
    static String sJDKVersion;
    private static char[] hex;
    private static short[] julianCalendarDays;
    private static Logger utilLogger;
    private static final int BASE_YEAR = 1753;
    private static final int BASE_BIAS = 53690;
    private static final int maxMillisecondsPerDay = 25919999;
    private static final int numNanoPer300thSec = 3333333;
    static final char LEFT_BRACKET = '[';
    static final char RIGHT_BRACKET = ']';
    static final char[] DOUBLE_RIGHT_BRACKET;
    private static final int MAX_SINGLE_BYTE_LENGTH = 255;
    private static final int MAX_DOUBLE_BYTE_LENGTH = 65535;

    Util() {
    }

    static short readShort(byte[] byArray, int n) {
        return (short)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8);
    }

    static int readUnsignedShort(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    static int readInt(byte[] byArray, int n) {
        int n2 = byArray[n + 0] & 0xFF;
        int n3 = (byArray[n + 1] & 0xFF) << 8;
        int n4 = (byArray[n + 2] & 0xFF) << 16;
        int n5 = (byArray[n + 3] & 0xFF) << 24;
        return n5 | n4 | n3 | n2;
    }

    static long readLong(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 7; i > 0; --i) {
            l += (long)(byArray[n + i] & 0xFF);
            l <<= 8;
        }
        return l + (long)(byArray[n] & 0xFF);
    }

    static int majorVersion() {
        return 1;
    }

    static String minorVersion() {
        String string = "0";
        return string;
    }

    static String getProgramName_65() {
        return "SQLServer";
    }

    static String nameAndVersion(boolean bl) {
        String string = "Microsoft SQL Server 2005 JDBC Driver";
        if (!bl) {
            return string;
        }
        return string + "(" + Util.majorVersion() + "." + Util.minorVersion() + ")";
    }

    static String getHostName() throws SQLServerException {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostName();
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            throw new SQLServerException(null, unknownHostException.getMessage(), "0", 0, false);
        }
    }

    static String javaSqlTypeToString(int n) {
        switch (n) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
        }
        return "UNKNOWN" + n;
    }

    static BigInteger bytesToBigInteger(byte[] byArray, int n, int n2, int n3) throws SQLServerException {
        int n4;
        byte[] byArray2 = new byte[n2 - 1];
        System.arraycopy(byArray, n, byArray2, 0, n2 - 1);
        for (n4 = 1; n4 < n2; ++n4) {
            byArray2[n2 - n4 - 1] = byArray[n + n4];
        }
        n4 = 1;
        if (byArray[n + 0] == 0) {
            n4 = -1;
        }
        BigInteger bigInteger = new BigInteger(n4, byArray2);
        return bigInteger;
    }

    static BigDecimal bytesToBigDecimal(byte[] byArray, int n, int n2, int n3) throws SQLServerException {
        BigInteger bigInteger = Util.bytesToBigInteger(byArray, n, n2, n3);
        BigDecimal bigDecimal = new BigDecimal(bigInteger, n3);
        return bigDecimal;
    }

    static BigDecimal moneyBytesToBigDecimal(SQLServerConnection sQLServerConnection, byte[] byArray, int n, int n2) throws SQLServerException {
        Object object;
        Serializable serializable;
        byte[] byArray2 = new byte[n2];
        switch (n2) {
            case 8: {
                byArray2[0] = byArray[n + 3];
                byArray2[1] = byArray[n + 2];
                byArray2[2] = byArray[n + 1];
                byArray2[3] = byArray[n + 0];
                byArray2[4] = byArray[n + 7];
                byArray2[5] = byArray[n + 6];
                byArray2[6] = byArray[n + 5];
                byArray2[7] = byArray[n + 4];
                break;
            }
            case 4: {
                byArray2[0] = byArray[n + 3];
                byArray2[1] = byArray[n + 2];
                byArray2[2] = byArray[n + 1];
                byArray2[3] = byArray[n + 0];
                break;
            }
            default: {
                serializable = new MessageFormat(SQLServerException.getErrString("R_invalidDataLength"));
                object = new Object[]{new Integer(n2)};
                SQLServerException.makeFromDriverError(sQLServerConnection, null, serializable.format(object), null, true);
            }
        }
        serializable = new BigInteger(byArray2);
        object = new BigDecimal((BigInteger)serializable, 4);
        return object;
    }

    static Float bytesToFloat(SQLServerConnection sQLServerConnection, byte[] byArray, int n, int n2) throws SQLServerException {
        switch (n2) {
            case 4: {
                int n3 = byArray[n + 0] & 0xFF;
                int n4 = (byArray[n + 1] & 0xFF) << 8;
                int n5 = (byArray[n + 2] & 0xFF) << 16;
                int n6 = (byArray[n + 3] & 0xFF) << 24;
                int n7 = n3 | n4 | n5 | n6;
                Float f = new Float(Float.intBitsToFloat(n7));
                return f;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidDataLength"));
        Object[] objectArray = new Object[]{new Integer(n2)};
        SQLServerException.makeFromDriverError(sQLServerConnection, null, messageFormat.format(objectArray), null, true);
        return null;
    }

    static Double bytesToDouble(SQLServerConnection sQLServerConnection, byte[] byArray, int n, int n2) throws SQLServerException {
        switch (n2) {
            case 8: {
                long l = (long)byArray[n + 0] & 0xFFL;
                long l2 = ((long)byArray[n + 1] & 0xFFL) << 8;
                long l3 = ((long)byArray[n + 2] & 0xFFL) << 16;
                long l4 = ((long)byArray[n + 3] & 0xFFL) << 24;
                long l5 = ((long)byArray[n + 4] & 0xFFL) << 32;
                long l6 = ((long)byArray[n + 5] & 0xFFL) << 40;
                long l7 = ((long)byArray[n + 6] & 0xFFL) << 48;
                long l8 = ((long)byArray[n + 7] & 0xFFL) << 56;
                long l9 = l | l2 | l3 | l4 | l5 | l6 | l7 | l8;
                Double d = new Double(Double.longBitsToDouble(l9));
                return d;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidDataLength"));
        Object[] objectArray = new Object[]{new Integer(n2)};
        SQLServerException.makeFromDriverError(sQLServerConnection, null, messageFormat.format(objectArray), null, true);
        return null;
    }

    static int leapDayCount(int n) {
        if (n < 0) {
            return 0;
        }
        long l = (n + 52) / 100;
        return (int)((long)(n >> 2) - l + (l + 1L >> 2));
    }

    static boolean isLeap(int n) {
        if (n % 400 == 0) {
            return true;
        }
        return n % 100 != 0 && n % 4 == 0;
    }

    static void timestampToBytes(long l, Calendar calendar, byte[] byArray, int n) {
        long l2 = 0L;
        int n2 = 0;
        Timestamp timestamp = new Timestamp(l);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (calendar != null) {
            calendar.setTime(new Date(l));
            n7 = calendar.get(1);
            n8 = calendar.get(5);
            n9 = calendar.get(2);
            n3 = calendar.get(11);
            n4 = calendar.get(12);
            n5 = calendar.get(13);
            n6 = timestamp.getNanos();
        } else {
            n7 = timestamp.getYear();
            n7 += 1900;
            n8 = timestamp.getDate();
            n9 = timestamp.getMonth();
            n3 = timestamp.getHours();
            n4 = timestamp.getMinutes();
            n5 = timestamp.getSeconds();
            n6 = timestamp.getNanos();
        }
        n2 = (n7 -= 1753) * 365 + Util.leapDayCount(n7) + julianCalendarDays[++n9] + n8;
        if (n9 > 2 && Util.isLeap(n7 + 1753)) {
            ++n2;
        }
        n2 = n2 - 53690 - 1;
        l2 = n3 * 60 * 18000 + n4 * 18000 + n5 * 300 + n6 / 3333333;
        if (n6 % 3333333 > 1666666) {
            ++l2;
        }
        if (l2 > 25919999L) {
            ++n2;
            l2 = 0L;
        }
        int n10 = n;
        byArray[n10++] = (byte)((n2 & 0xFF) >> 0);
        byArray[n10++] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n10++] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[n10++] = (byte)((n2 & 0xFF000000) >> 24);
        byArray[n10++] = (byte)((l2 & 0xFFL) >> 0);
        byArray[n10++] = (byte)((l2 & 0xFF00L) >> 8);
        byArray[n10++] = (byte)((l2 & 0xFF0000L) >> 16);
        byArray[n10++] = (byte)((l2 & 0xFFFFFFFFFF000000L) >> 24);
    }

    static Timestamp daysAndTimeToTimestamp(int n, int n2, Calendar calendar) {
        int n3;
        int n4;
        int n5;
        int n6 = n;
        ++n6;
        int n7 = n2;
        int n8 = n7 / 18000;
        float f = n7 % 18000;
        if ((n5 = (n4 = (int)((f -= (float)((n3 = (int)(f / 300.0f)) * 300)) / 300.0f * 1.0E9f)) % 1000000) > 0) {
            n4 = n4 / 1000000 * 1000000;
            if (n5 > 500000) {
                n4 += 1000000;
            }
        }
        Timestamp timestamp = new Timestamp(0, 0, n6, 0, n8, n3, n4);
        if (calendar != null) {
            calendar.set(timestamp.getYear() + 1900, timestamp.getMonth(), timestamp.getDate(), timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
            timestamp = new Timestamp(calendar.getTime().getTime());
            timestamp.setNanos(n4);
        }
        return timestamp;
    }

    static Timestamp bytesToTimestamp(SQLServerConnection sQLServerConnection, byte[] byArray, int n, int n2, Calendar calendar) throws SQLServerException {
        Timestamp timestamp = null;
        switch (n2) {
            case 8: {
                int n3 = byArray[n + 0] & 0xFF;
                int n4 = (byArray[n + 1] & 0xFF) << 8;
                int n5 = (byArray[n + 2] & 0xFF) << 16;
                int n6 = (byArray[n + 3] & 0xFF) << 24;
                int n7 = n6 | n5 | n4 | n3;
                n3 = byArray[n + 4] & 0xFF;
                n4 = (byArray[n + 5] & 0xFF) << 8;
                n5 = (byArray[n + 6] & 0xFF) << 16;
                n6 = (byArray[n + 7] & 0xFF) << 24;
                int n8 = n6 | n5 | n4 | n3;
                timestamp = Util.daysAndTimeToTimestamp(n7, n8, calendar);
                return timestamp;
            }
            case 4: {
                int n9 = byArray[n + 0] & 0xFF;
                int n10 = (byArray[n + 1] & 0xFF) << 8;
                int n11 = n10 | n9;
                n9 = byArray[n + 2] & 0xFF;
                n10 = (byArray[n + 3] & 0xFF) << 8;
                int n12 = n10 | n9;
                timestamp = Util.daysAndTimeToTimestamp(n11, n12 * 18000, calendar);
                return timestamp;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidDataLength"));
        Object[] objectArray = new Object[]{new Integer(n2)};
        SQLServerException.makeFromDriverError(sQLServerConnection, null, messageFormat.format(objectArray), null, true);
        return null;
    }

    static String normalizePropertyNames(String string) {
        int n;
        if (null == string) {
            return string;
        }
        for (n = 0; n < SQLServerDriver.driverPropertiesSynonyms.length; ++n) {
            if (!SQLServerDriver.driverPropertiesSynonyms[n][0].equalsIgnoreCase(string)) continue;
            return SQLServerDriver.driverPropertiesSynonyms[n][1];
        }
        for (n = 0; n < SQLServerDriver.driverProperties.length; ++n) {
            if (!SQLServerDriver.driverProperties[n].equalsIgnoreCase(string)) continue;
            return SQLServerDriver.driverProperties[n];
        }
        if (utilLogger.isLoggable(Level.FINE)) {
            utilLogger.fine("Unknown property" + string);
        }
        return null;
    }

    static Properties parseUrl(String string) throws SQLServerException {
        Properties properties = new Properties();
        String string2 = string;
        String string3 = "jdbc:sqlserver://";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        if (!string2.startsWith(string3)) {
            return null;
        }
        string2 = string2.substring(string3.length());
        int n = 0;
        int n2 = 0;
        block18: for (n = 0; n < string2.length(); ++n) {
            char c = string2.charAt(n);
            switch (n2) {
                case 0: {
                    if (c == ';') {
                        n2 = 7;
                        continue block18;
                    }
                    string4 = string4 + c;
                    n2 = 1;
                    continue block18;
                }
                case 1: {
                    if (c == ';' || c == ':' || c == '\\') {
                        if ((string4 = string4.trim()).length() > 0) {
                            properties.put("serverName", string4);
                            if (utilLogger.isLoggable(Level.FINE)) {
                                utilLogger.fine("Property : serverName Value:" + string4);
                            }
                        }
                        string4 = "";
                        if (c == ';') {
                            n2 = 7;
                            continue block18;
                        }
                        if (c == ':') {
                            n2 = 2;
                            continue block18;
                        }
                        n2 = 3;
                        continue block18;
                    }
                    string4 = string4 + c;
                    continue block18;
                }
                case 2: {
                    if (c == ';') {
                        string4 = string4.trim();
                        if (utilLogger.isLoggable(Level.FINE)) {
                            utilLogger.fine("Property : portNumber Value:" + string4);
                        }
                        properties.put("portNumber", string4);
                        string4 = "";
                        n2 = 7;
                        continue block18;
                    }
                    string4 = string4 + c;
                    continue block18;
                }
                case 3: {
                    if (c == ';' || c == ':') {
                        string4 = string4.trim();
                        if (utilLogger.isLoggable(Level.FINE)) {
                            utilLogger.fine("Property : instanceName Value:" + string6);
                        }
                        properties.put("instanceName", string4.toLowerCase(Locale.US));
                        string4 = "";
                        if (c == ';') {
                            n2 = 7;
                            continue block18;
                        }
                        n2 = 2;
                        continue block18;
                    }
                    string4 = string4 + c;
                    continue block18;
                }
                case 7: {
                    if (c == '=') {
                        if ((string5 = string5.trim()).length() <= 0) {
                            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        }
                        n2 = 6;
                        continue block18;
                    }
                    if (c == ';') {
                        if ((string5 = string5.trim()).length() <= 0) continue block18;
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        continue block18;
                    }
                    string5 = string5 + c;
                    continue block18;
                }
                case 6: {
                    if (c == ';') {
                        string6 = string6.trim();
                        if (null != (string5 = Util.normalizePropertyNames(string5))) {
                            if (utilLogger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                                utilLogger.fine("Property:" + string5 + "Value:" + string6);
                            }
                            properties.put(string5, string6);
                        }
                        string5 = "";
                        string6 = "";
                        n2 = 7;
                        continue block18;
                    }
                    if (c == '{') {
                        n2 = 4;
                        if ((string6 = string6.trim()).length() <= 0) continue block18;
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        continue block18;
                    }
                    string6 = string6 + c;
                    continue block18;
                }
                case 4: {
                    if (c == '}') {
                        if (null != (string5 = Util.normalizePropertyNames(string5))) {
                            if (utilLogger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                                utilLogger.fine("Property:" + string5 + "Value:" + string6);
                            }
                            properties.put(string5, string6);
                        }
                        string5 = "";
                        string6 = "";
                        n2 = 5;
                        continue block18;
                    }
                    string6 = string6 + c;
                    continue block18;
                }
                case 5: {
                    if (c == ';') {
                        n2 = 7;
                        continue block18;
                    }
                    if (c == ' ') continue block18;
                    SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                }
            }
        }
        switch (n2) {
            case 1: {
                string4 = string4.trim();
                if (string4.length() <= 0) break;
                if (utilLogger.isLoggable(Level.FINE)) {
                    utilLogger.fine("Property : serverName Value:" + string4);
                }
                properties.put("serverName", string4);
                break;
            }
            case 2: {
                string4 = string4.trim();
                if (utilLogger.isLoggable(Level.FINE)) {
                    utilLogger.fine("Property : portNumber Value:" + string4);
                }
                properties.put("portNumber", string4);
            }
            case 3: {
                string4 = string4.trim();
                if (utilLogger.isLoggable(Level.FINE)) {
                    utilLogger.fine("Property : instanceName Value:" + string4);
                }
                properties.put("instanceName", string4);
                break;
            }
            case 6: {
                string6 = string6.trim();
                string5 = Util.normalizePropertyNames(string5);
                if (null == string5) break;
                if (utilLogger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                    utilLogger.fine("Property:" + string5 + "Value:" + string6);
                }
                properties.put(string5, string6);
                break;
            }
            case 0: 
            case 5: {
                break;
            }
            case 7: {
                string5 = string5.trim();
                if (string5.length() <= 0) break;
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                break;
            }
            default: {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
            }
        }
        return properties;
    }

    static byte[] GUIDToBytes(String string) throws SQLServerException {
        int n = string.length();
        byte[] byArray = new byte[16];
        int n2 = 0;
        int n3 = 0;
        if (n != 36) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_stringNotInHex"), null, false);
        }
        while (n2 + 1 < n && 16 != n3) {
            char c;
            if ((c = string.charAt(n2++)) == '-') {
                if (9 == n2 || 14 == n2 || 19 == n2 || 24 == n2) continue;
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_stringNotInHex"), null, false);
            }
            byte by = ParameterUtils.CharToHex(c);
            by = (byte)(by << 4);
            c = string.charAt(n2++);
            byte by2 = ParameterUtils.CharToHex(c);
            int n4 = n3;
            if (n3 == 0) {
                n4 = 3;
            }
            if (n3 == 1) {
                n4 = 2;
            }
            if (n3 == 2) {
                n4 = 1;
            }
            if (n3 == 3) {
                n4 = 0;
            }
            if (n3 == 4) {
                n4 = 5;
            }
            if (n3 == 5) {
                n4 = 4;
            }
            if (n3 == 6) {
                n4 = 7;
            }
            if (n3 == 7) {
                n4 = 6;
            }
            byArray[n4] = (byte)(by + by2);
            ++n3;
        }
        return byArray;
    }

    static String bytesToGUID(byte[] byArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < 4; ++n) {
            stringBuffer.append(hex[(byArray[3 - n] & 0xF0) >> 4]);
            stringBuffer.append(hex[byArray[3 - n] & 0xF]);
        }
        stringBuffer.append("-");
        for (n = 0; n < 2; ++n) {
            stringBuffer.append(hex[(byArray[5 - n] & 0xF0) >> 4]);
            stringBuffer.append(hex[byArray[5 - n] & 0xF]);
        }
        stringBuffer.append("-");
        for (n = 0; n < 2; ++n) {
            stringBuffer.append(hex[(byArray[7 - n] & 0xF0) >> 4]);
            stringBuffer.append(hex[byArray[7 - n] & 0xF]);
        }
        stringBuffer.append("-");
        for (n = 0; n < 2; ++n) {
            stringBuffer.append(hex[(byArray[8 + n] & 0xF0) >> 4]);
            stringBuffer.append(hex[byArray[8 + n] & 0xF]);
        }
        stringBuffer.append("-");
        for (n = 0; n < 6; ++n) {
            stringBuffer.append(hex[(byArray[10 + n] & 0xF0) >> 4]);
            stringBuffer.append(hex[byArray[10 + n] & 0xF]);
        }
        return new String(stringBuffer);
    }

    static SQLServerException notSupportedBySQLServer(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_notSupportedBySQL"));
        Object[] objectArray = new Object[]{new String(string)};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "0A000", false);
        return null;
    }

    static boolean isBigInt(int n, int n2) {
        return n == 38 && n2 == 8;
    }

    static void println(String string) {
        System.out.println(string);
    }

    static void print(String string) {
        System.out.print(string);
    }

    static String escapeSQLId(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('[');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (']' == c) {
                stringBuffer.append(DOUBLE_RIGHT_BRACKET);
                continue;
            }
            stringBuffer.append(c);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static void checkSingleByteLength(int n) throws SQLServerException {
        if (n < 0 || n > 255) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidDataLength"));
            Object[] objectArray = new Object[]{new Integer(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static void checkDoubleByteLength(int n) throws SQLServerException {
        if (n < 0 || n > 65535) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidDataLength"));
            Object[] objectArray = new Object[]{new Integer(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static String readUnicodeString(byte[] byArray, int n, int n2) throws SQLServerException {
        try {
            return new String(byArray, n, n2, "UTF-16LE");
        }
        catch (Exception exception) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_stringReadError"));
            Object[] objectArray = new Object[]{new Integer(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static int writeUnicodeString(byte[] byArray, int n, String string) throws SQLServerException {
        try {
            byte[] byArray2 = string.getBytes("UTF-16LE");
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            return byArray2.length;
        }
        catch (Exception exception) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_stringWriteError"));
            Object[] objectArray = new Object[]{new Integer(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static String byteToHexDisplayString(byte[] byArray) {
        if (null == byArray) {
            return "(null)";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2 + 2);
        stringBuffer.append("0x");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuffer.append(hex[(n & 0xF0) >> 4]);
            stringBuffer.append(hex[n & 0xF]);
        }
        return stringBuffer.toString();
    }

    static String lookupHostName() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (null != inetAddress) {
            String string = inetAddress.getHostName();
            if (null != string && string.length() > 0) {
                return string;
            }
            string = inetAddress.getHostAddress();
            if (null != string && string.length() > 0) {
                return string;
            }
        }
        return "WSID Not Available";
    }

    static {
        int n;
        hex = null;
        julianCalendarDays = new short[]{-1, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        try {
            sJDKVersion = System.getProperties().getProperty("java.version");
        }
        catch (Exception exception) {
            sJDKVersion = "Unknown";
        }
        utilLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.Util");
        hex = new char[16];
        int n2 = 0;
        for (n = 0; n < 10; ++n) {
            Util.hex[n2++] = (char)(48 + n);
        }
        for (n = 0; n < 6; ++n) {
            Util.hex[n2++] = (char)(65 + n);
        }
        TimeZone timeZone = TimeZone.getDefault();
        try {
            String string = System.getProperty("file.encoding");
            if (string.trim().equals("Cp1252")) {
                bCp1252 = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DOUBLE_RIGHT_BRACKET = new char[]{']', ']'};
    }
}

