/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.base;

import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.base.WebTestModule;
import com.mockrunner.mock.web.WebMockObjectFactory;
import com.mockrunner.util.common.StringUtil;
import com.mockrunner.util.web.XmlUtil;
import java.io.BufferedReader;
import java.io.StringReader;
import org.jdom.Document;

public abstract class HTMLOutputModule
extends WebTestModule {
    private boolean caseSensitive = true;

    public HTMLOutputModule(WebMockObjectFactory mockFactory) {
        super(mockFactory);
    }

    public abstract String getOutput();

    public BufferedReader getOutputAsBufferedReader() {
        return new BufferedReader(new StringReader(this.getOutput()));
    }

    public org.w3c.dom.Document getOutputAsW3CDocument() {
        return XmlUtil.parseHTML(this.getOutput());
    }

    public Document getOutputAsJDOMDocument() {
        return XmlUtil.createJDOMDocument(this.getOutputAsW3CDocument());
    }

    public String getOutputAsWellformedXML() {
        return XmlUtil.createStringFromJDOMDocument(this.getOutputAsJDOMDocument());
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void verifyOutput(String expectedOutput) {
        String actualOutput = this.getOutput();
        if (!StringUtil.matchesExact(actualOutput, expectedOutput, this.caseSensitive)) {
            throw new VerifyFailedException("actual output: " + actualOutput + " does not match expected output");
        }
    }

    public void verifyOutputContains(String expectedOutput) {
        String actualOutput = this.getOutput();
        if (!StringUtil.matchesContains(actualOutput, expectedOutput, this.caseSensitive)) {
            throw new VerifyFailedException("actual output: " + actualOutput + " does not match expected output");
        }
    }

    public void verifyOutputRegularExpression(String expression) {
        String actualOutput = this.getOutput();
        if (!StringUtil.matchesPerl5(actualOutput, expression, this.caseSensitive)) {
            throw new VerifyFailedException("actual output: " + actualOutput + " does not match expected output");
        }
    }
}

