/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.connector;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.connector.InteractionImplementor;
import com.mockrunner.mock.connector.cci.MockStreamableByteArrayRecord;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.resource.ResourceException;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.Streamable;

public class StreamableRecordByteArrayInteraction
implements InteractionImplementor {
    private boolean enabled;
    private byte[] expectedRequest;
    private byte[] responseData;
    private Class responseClass;
    private Record responseRecord;

    public StreamableRecordByteArrayInteraction() {
        this(null, null, MockStreamableByteArrayRecord.class);
    }

    public StreamableRecordByteArrayInteraction(byte[] responseData) {
        this(null, responseData, MockStreamableByteArrayRecord.class);
    }

    public StreamableRecordByteArrayInteraction(byte[] expectedRequest, byte[] responseData) {
        this(expectedRequest, responseData, MockStreamableByteArrayRecord.class);
    }

    public StreamableRecordByteArrayInteraction(byte[] responseData, Class responseClass) {
        this(null, responseData, responseClass);
    }

    public StreamableRecordByteArrayInteraction(byte[] expectedRequest, byte[] responseData, Class responseClass) {
        this.setExpectedRequest(expectedRequest);
        this.setResponse(responseData, responseClass);
        this.enabled = true;
    }

    public StreamableRecordByteArrayInteraction(byte[] expectedRequest, Record responseRecord) {
        this.setExpectedRequest(expectedRequest);
        this.setResponse(responseRecord);
        this.enabled = true;
    }

    public StreamableRecordByteArrayInteraction(Record responseRecord) {
        this(null, responseRecord);
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void setExpectedRequest(byte[] expectedRequest) {
        this.expectedRequest = (byte[])(null == expectedRequest ? null : (byte[])expectedRequest.clone());
    }

    public void setExpectedRequest(InputStream expectedRequest) {
        this.expectedRequest = (byte[])(null == expectedRequest ? null : StreamUtil.getStreamAsByteArray(expectedRequest));
    }

    public void setResponse(byte[] responseData) {
        this.setResponse(responseData, MockStreamableByteArrayRecord.class);
    }

    public void setResponse(byte[] responseData, Class responseClass) {
        if (!this.isResponseClassAcceptable(responseClass)) {
            throw new IllegalArgumentException("responseClass must implement " + Streamable.class.getName() + " and " + Record.class.getName());
        }
        this.responseData = (byte[])(null == responseData ? null : (byte[])responseData.clone());
        this.responseClass = responseClass;
    }

    public void setResponse(InputStream responseData) {
        this.setResponse(responseData, MockStreamableByteArrayRecord.class);
    }

    public void setResponse(InputStream responseData, Class responseClass) {
        if (!this.isResponseClassAcceptable(responseClass)) {
            throw new IllegalArgumentException("responseClass must implement " + Streamable.class.getName() + " and " + Record.class.getName());
        }
        this.responseData = (byte[])(null == responseData ? null : StreamUtil.getStreamAsByteArray(responseData));
        this.responseClass = responseClass;
    }

    public void setResponse(Record responseRecord) {
        this.responseRecord = responseRecord;
    }

    public boolean canHandle(InteractionSpec interactionSpec, Record actualRequest, Record actualResponse) {
        if (!this.enabled) {
            return false;
        }
        if (!this.isResponseAcceptable(actualResponse)) {
            return false;
        }
        return this.doesRequestMatch(actualRequest);
    }

    private boolean doesRequestMatch(Record request) {
        if (null == this.expectedRequest) {
            return true;
        }
        if (null == request) {
            return false;
        }
        if (request instanceof Streamable) {
            try {
                Streamable streamableRequest = (Streamable)request;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                streamableRequest.write((OutputStream)stream);
                stream.flush();
                return Arrays.equals(this.expectedRequest, stream.toByteArray());
            }
            catch (Exception exc) {
                throw new NestedApplicationException(exc);
            }
        }
        return false;
    }

    private boolean isResponseAcceptable(Record response) {
        return null == response || response instanceof Streamable;
    }

    private boolean isResponseClassAcceptable(Class responseClass) {
        return null == responseClass || Streamable.class.isAssignableFrom(responseClass) && Record.class.isAssignableFrom(responseClass);
    }

    public Record execute(InteractionSpec interactionSpec, Record actualRequest) throws ResourceException {
        if (!this.canHandle(interactionSpec, actualRequest, null)) {
            return null;
        }
        if (null != this.responseRecord) {
            return this.responseRecord;
        }
        MockStreamableByteArrayRecord response = null;
        try {
            response = null == this.responseClass ? new MockStreamableByteArrayRecord() : (Streamable)this.responseClass.newInstance();
            if (null != this.responseData) {
                response.read(new ByteArrayInputStream(this.responseData));
            }
        }
        catch (Exception exc) {
            ResourceException resExc = new ResourceException("execute() failed");
            resExc.setLinkedException(exc);
            throw resExc;
        }
        return response;
    }

    public boolean execute(InteractionSpec interactionSpec, Record actualRequest, Record actualResponse) throws ResourceException {
        if (!this.canHandle(interactionSpec, actualRequest, actualResponse)) {
            return false;
        }
        try {
            if (null != this.responseData && null != actualResponse) {
                ((Streamable)actualResponse).read((InputStream)new ByteArrayInputStream(this.responseData));
            }
        }
        catch (Exception exc) {
            ResourceException resExc = new ResourceException("execute() failed");
            resExc.setLinkedException(exc);
            throw resExc;
        }
        return true;
    }
}

