/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.connector.cci;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.connector.cci.MockRecord;
import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.resource.cci.Streamable;

public class MockStreamableByteArrayRecord
extends MockRecord
implements Streamable {
    private byte[] content = null;

    public MockStreamableByteArrayRecord() {
        this(MockStreamableByteArrayRecord.class.getName());
    }

    public MockStreamableByteArrayRecord(String name) {
        this(name, name);
    }

    public MockStreamableByteArrayRecord(String name, String description) {
        super(name, description);
    }

    public byte[] getContent() {
        if (null == this.content) {
            return null;
        }
        return (byte[])this.content.clone();
    }

    public void setContent(byte[] content) {
        this.content = (byte[])(null == content ? null : (byte[])content.clone());
    }

    public void read(InputStream stream) throws IOException {
        this.content = (byte[])(null == stream ? null : StreamUtil.getStreamAsByteArray(stream));
    }

    public void write(OutputStream stream) throws IOException {
        if (null != stream && null != this.content) {
            stream.write(this.content);
            stream.flush();
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        MockStreamableByteArrayRecord other = (MockStreamableByteArrayRecord)object;
        return ArrayUtil.areArraysEqual(this.content, other.content);
    }

    public int hashCode() {
        return super.hashCode() * 31 + ArrayUtil.computeHashCode(this.content);
    }

    public Object clone() {
        try {
            MockStreamableByteArrayRecord clone = (MockStreamableByteArrayRecord)super.clone();
            clone.setContent(this.content);
            return clone;
        }
        catch (Exception exc) {
            throw new NestedApplicationException(exc);
        }
    }
}

