/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.web.MockServletOutputStream;
import com.mockrunner.util.common.CaseAwareMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class MockHttpServletResponse
implements HttpServletResponse {
    private PrintWriter writer;
    private MockServletOutputStream outputStream;
    private Map headers;
    private Locale locale;
    private String characterEncoding;
    private int bufferSize;
    private boolean wasErrorSent;
    private boolean wasRedirectSent;
    private int errorCode;
    private int statusCode;
    private List cookies;

    public MockHttpServletResponse() {
        this.resetAll();
    }

    public void resetAll() {
        this.headers = new CaseAwareMap();
        this.characterEncoding = "ISO-8859-1";
        this.bufferSize = 8192;
        this.wasErrorSent = false;
        this.wasRedirectSent = false;
        this.errorCode = 200;
        this.statusCode = 200;
        this.cookies = new ArrayList();
        this.outputStream = new MockServletOutputStream(this.characterEncoding);
        try {
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.outputStream), this.characterEncoding), true);
        }
        catch (UnsupportedEncodingException exc) {
            throw new NestedApplicationException(exc);
        }
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return url;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public String getOutputStreamContent() {
        return this.outputStream.getContent();
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void addDateHeader(String key, long date) {
        this.addHeader(key, this.getDateString(date));
    }

    public void addHeader(String key, String value) {
        ArrayList<String> valueList = (ArrayList<String>)this.headers.get(key);
        if (null == valueList) {
            valueList = new ArrayList<String>();
            this.headers.put(key, valueList);
        }
        valueList.add(value);
    }

    public void addIntHeader(String key, int value) {
        String stringValue = new Integer(value).toString();
        this.addHeader(key, stringValue);
    }

    public boolean containsHeader(String key) {
        return this.headers.containsKey(key);
    }

    public void sendError(int code, String message) throws IOException {
        this.errorCode = code;
        this.wasErrorSent = true;
    }

    public void sendError(int code) throws IOException {
        this.errorCode = code;
        this.wasErrorSent = true;
    }

    public void sendRedirect(String location) throws IOException {
        this.setHeader("Location", location);
        this.wasRedirectSent = true;
    }

    public void setDateHeader(String key, long date) {
        this.setHeader(key, this.getDateString(date));
    }

    public void setHeader(String key, String value) {
        ArrayList<String> valueList = new ArrayList<String>();
        this.headers.put(key, valueList);
        valueList.add(value);
    }

    public void setIntHeader(String key, int value) {
        String stringValue = new Integer(value).toString();
        this.setHeader(key, stringValue);
    }

    public void setStatus(int code, String message) {
        this.statusCode = code;
    }

    public void setStatus(int code) {
        this.statusCode = code;
    }

    public void flushBuffer() throws IOException {
        this.writer.flush();
        this.outputStream.flush();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
        this.outputStream.setEncoding(encoding);
        try {
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.outputStream), this.characterEncoding), true);
        }
        catch (UnsupportedEncodingException exc) {
            throw new NestedApplicationException(exc);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
        this.errorCode = 200;
        this.statusCode = 200;
        this.clearHeaders();
        this.resetBuffer();
    }

    public void resetBuffer() {
        this.outputStream.clearContent();
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setContentLength(int length) {
        this.setIntHeader("Content-Length", length);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public Collection getHeaderNames() {
        return this.headers.keySet();
    }

    public Collection getHeaders(String name) {
        List headerList = (List)this.headers.get(name);
        if (null == headerList) {
            return null;
        }
        return headerList;
    }

    public List getHeaderList(String key) {
        return (List)this.headers.get(key);
    }

    public String getHeader(String key) {
        List list = this.getHeaderList(key);
        if (null == list || 0 == list.size()) {
            return null;
        }
        return (String)list.get(0);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getStatus() {
        return this.getStatusCode();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public List getCookies() {
        return this.cookies;
    }

    public boolean wasErrorSent() {
        return this.wasErrorSent;
    }

    public boolean wasRedirectSent() {
        return this.wasRedirectSent;
    }

    private String getDateString(long date) {
        Date dateValue = new Date(date);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(dateValue);
    }
}

