/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.connector;

import com.mockrunner.connector.InteractionHandler;
import com.mockrunner.connector.InteractionImplementor;
import javax.resource.ResourceException;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import junit.framework.TestCase;

public class InteractionHandlerTest
extends TestCase {
    private InteractionHandler interactionHandler;

    protected void setUp() throws Exception {
        this.interactionHandler = new InteractionHandler();
    }

    protected void tearDown() throws Exception {
        this.interactionHandler = null;
    }

    public void testExecuteReturnsBoolean() throws Exception {
        InteractionHandlerTest.assertFalse((boolean)this.interactionHandler.execute(new TestInteractionSpec(), new TestRecord(), new TestRecord()));
        TestInteractionImplementor implementor1 = new TestInteractionImplementor(false);
        TestInteractionImplementor implementor2 = new TestInteractionImplementor(true);
        implementor2.setBooleanReturnValue(false);
        TestInteractionImplementor implementor3 = new TestInteractionImplementor(false);
        this.interactionHandler.addImplementor(implementor1);
        this.interactionHandler.addImplementor(implementor2);
        this.interactionHandler.addImplementor(implementor3);
        InteractionHandlerTest.assertFalse((boolean)this.interactionHandler.execute(new TestInteractionSpec(), new TestRecord(), new TestRecord()));
        InteractionHandlerTest.assertFalse((boolean)implementor1.wasExecuteCalled());
        InteractionHandlerTest.assertTrue((boolean)implementor2.wasExecuteCalled());
        InteractionHandlerTest.assertFalse((boolean)implementor3.wasExecuteCalled());
        this.interactionHandler.clearImplementors();
        implementor1 = new TestInteractionImplementor(false);
        implementor2 = new TestInteractionImplementor(false);
        this.interactionHandler.addImplementor(implementor1);
        this.interactionHandler.addImplementor(implementor2);
        InteractionHandlerTest.assertFalse((boolean)this.interactionHandler.execute(new TestInteractionSpec(), new TestRecord(), new TestRecord()));
        InteractionHandlerTest.assertFalse((boolean)implementor1.wasExecuteCalled());
        InteractionHandlerTest.assertFalse((boolean)implementor2.wasExecuteCalled());
        this.interactionHandler.clearImplementors();
        implementor1 = new TestInteractionImplementor(true);
        implementor2 = new TestInteractionImplementor(false);
        this.interactionHandler.addImplementor(implementor1);
        this.interactionHandler.addImplementor(implementor2);
        InteractionHandlerTest.assertTrue((boolean)this.interactionHandler.execute(new TestInteractionSpec(), new TestRecord(), new TestRecord()));
        InteractionHandlerTest.assertTrue((boolean)implementor1.wasExecuteCalled());
        InteractionHandlerTest.assertFalse((boolean)implementor2.wasExecuteCalled());
    }

    public void testExecuteReturnsRecord() throws Exception {
        InteractionHandlerTest.assertNull((Object)this.interactionHandler.execute(new TestInteractionSpec(), new TestRecord()));
        TestInteractionImplementor implementor1 = new TestInteractionImplementor(false);
        TestInteractionImplementor implementor2 = new TestInteractionImplementor(true);
        TestRecord testRecord = new TestRecord();
        implementor2.setRecordReturnValue(testRecord);
        TestInteractionImplementor implementor3 = new TestInteractionImplementor(false);
        this.interactionHandler.addImplementor(implementor1);
        this.interactionHandler.addImplementor(implementor2);
        this.interactionHandler.addImplementor(implementor3);
        InteractionHandlerTest.assertSame((Object)testRecord, (Object)this.interactionHandler.execute(new TestInteractionSpec(), new TestRecord()));
        InteractionHandlerTest.assertFalse((boolean)implementor1.wasExecuteCalled());
        InteractionHandlerTest.assertTrue((boolean)implementor2.wasExecuteCalled());
        InteractionHandlerTest.assertFalse((boolean)implementor3.wasExecuteCalled());
        this.interactionHandler.clearImplementors();
        implementor1 = new TestInteractionImplementor(false);
        implementor2 = new TestInteractionImplementor(false);
        this.interactionHandler.addImplementor(implementor1);
        this.interactionHandler.addImplementor(implementor2);
        InteractionHandlerTest.assertNull((Object)this.interactionHandler.execute(new TestInteractionSpec(), new TestRecord()));
        InteractionHandlerTest.assertFalse((boolean)implementor1.wasExecuteCalled());
        InteractionHandlerTest.assertFalse((boolean)implementor2.wasExecuteCalled());
        this.interactionHandler.clearImplementors();
        implementor1 = new TestInteractionImplementor(true);
        implementor2 = new TestInteractionImplementor(false);
        this.interactionHandler.addImplementor(implementor1);
        this.interactionHandler.addImplementor(implementor2);
        InteractionHandlerTest.assertNull((Object)this.interactionHandler.execute(new TestInteractionSpec(), new TestRecord()));
        InteractionHandlerTest.assertTrue((boolean)implementor1.wasExecuteCalled());
        InteractionHandlerTest.assertFalse((boolean)implementor2.wasExecuteCalled());
    }

    private class TestInteractionImplementor
    implements InteractionImplementor {
        private boolean doProcess = false;
        private boolean wasExecuteCalled = false;
        private boolean booleanReturnValue = true;
        private Record recordReturnValue = null;

        public TestInteractionImplementor(boolean doProcess) {
            this.doProcess = doProcess;
        }

        public void setBooleanReturnValue(boolean booleanReturnValue) {
            this.booleanReturnValue = booleanReturnValue;
        }

        public void setRecordReturnValue(Record recordReturnValue) {
            this.recordReturnValue = recordReturnValue;
        }

        public boolean canHandle(InteractionSpec interactionSpec, Record actualRequest, Record actualResponse) {
            return this.doProcess;
        }

        public Record execute(InteractionSpec interactionSpec, Record actualRequest) throws ResourceException {
            this.wasExecuteCalled = true;
            return this.recordReturnValue;
        }

        public boolean execute(InteractionSpec is, Record request, Record response) throws ResourceException {
            this.wasExecuteCalled = true;
            return this.booleanReturnValue;
        }

        public boolean wasExecuteCalled() {
            return this.wasExecuteCalled;
        }
    }

    private class TestRecord
    implements Record {
        private TestRecord() {
        }

        public String getRecordName() {
            return null;
        }

        public String getRecordShortDescription() {
            return null;
        }

        public void setRecordName(String name) {
        }

        public void setRecordShortDescription(String description) {
        }

        public Object clone() throws CloneNotSupportedException {
            return null;
        }
    }

    private class TestInteractionSpec
    implements InteractionSpec {
        private TestInteractionSpec() {
        }
    }
}

