/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.connector;

import com.mockrunner.connector.MappedRecordInteraction;
import com.mockrunner.mock.connector.cci.MockIndexedRecord;
import com.mockrunner.mock.connector.cci.MockMappedRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import javax.resource.cci.Streamable;
import junit.framework.TestCase;

public class MappedRecordInteractionTest
extends TestCase {
    public void testSetResponseArguments() {
        MappedRecordInteraction interaction = new MappedRecordInteraction();
        try {
            interaction.setResponse(new HashMap(), String.class);
            MappedRecordInteractionTest.fail();
        }
        catch (IllegalArgumentException exc) {
            // empty catch block
        }
        try {
            interaction.setResponse(new HashMap(), Streamable.class);
            MappedRecordInteractionTest.fail();
        }
        catch (IllegalArgumentException exc) {
            // empty catch block
        }
        interaction.setResponse(new HashMap(), null);
        interaction.setResponse(new HashMap(), TestRecord.class);
        interaction.setResponse(new HashMap(), MockMappedRecord.class);
        try {
            interaction = new MappedRecordInteraction(new HashMap(), Integer.class);
            MappedRecordInteractionTest.fail();
        }
        catch (IllegalArgumentException exc) {
            // empty catch block
        }
        try {
            interaction = new MappedRecordInteraction(new HashMap(), Record.class);
            MappedRecordInteractionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        interaction = new MappedRecordInteraction(new HashMap(), (Class)null);
    }

    public void testCanHandle() {
        MappedRecordInteraction interaction = new MappedRecordInteraction();
        InteractionSpec spec = new InteractionSpec(){};
        MappedRecordInteractionTest.assertTrue((boolean)interaction.canHandle(spec, null, null));
        MappedRecordInteractionTest.assertTrue((boolean)interaction.canHandle(spec, null, new MockMappedRecord()));
        MappedRecordInteractionTest.assertFalse((boolean)interaction.canHandle(spec, null, new MockIndexedRecord()));
        MappedRecordInteractionTest.assertTrue((boolean)interaction.canHandle(spec, new MockMappedRecord(), new MockMappedRecord()));
        HashMap<String, Object> expectedRequestMap = new HashMap<String, Object>();
        expectedRequestMap.put("key1", "value1");
        expectedRequestMap.put("key2", null);
        expectedRequestMap.put("key3", "value3");
        interaction.setExpectedRequest(expectedRequestMap);
        expectedRequestMap.put("key4", "value4");
        MappedRecordInteractionTest.assertFalse((boolean)interaction.canHandle(spec, null, new MockMappedRecord()));
        MappedRecordInteractionTest.assertFalse((boolean)interaction.canHandle(spec, new MockMappedRecord(), new MockMappedRecord()));
        MockMappedRecord request = new MockMappedRecord();
        request.put("key1", "value1");
        request.put("key2", null);
        request.put("key3", "value3");
        MappedRecordInteractionTest.assertTrue((boolean)interaction.canHandle(spec, request, new MockMappedRecord()));
        request.put("key4", "value4");
        MappedRecordInteractionTest.assertFalse((boolean)interaction.canHandle(spec, request, new MockMappedRecord()));
        interaction.setExpectedRequest((Map)((Object)request));
        MappedRecordInteractionTest.assertTrue((boolean)interaction.canHandle(spec, request, new MockMappedRecord()));
        expectedRequestMap = new HashMap();
        expectedRequestMap.put("key1", new Integer(5));
        expectedRequestMap.put("key2", new Integer(6));
        expectedRequestMap.put("key3", new Integer(7));
        interaction = new MappedRecordInteraction(expectedRequestMap, new MockMappedRecord());
        MappedRecordInteractionTest.assertFalse((boolean)interaction.canHandle(spec, request, new MockMappedRecord()));
        request = new MockMappedRecord();
        request.put("key1", new Integer(5));
        request.put("key2", new Integer(1));
        request.put("key3", new Integer(7));
        request.put("key4", new Integer(8));
        MappedRecordInteractionTest.assertFalse((boolean)interaction.canHandle(spec, request, new MockMappedRecord()));
        request.remove("key4");
        MappedRecordInteractionTest.assertFalse((boolean)interaction.canHandle(spec, request, new MockMappedRecord()));
        request.put("key2", new Integer(6));
        MappedRecordInteractionTest.assertTrue((boolean)interaction.canHandle(spec, request, new MockMappedRecord()));
        interaction = new MappedRecordInteraction(new HashMap(), MockMappedRecord.class);
        MappedRecordInteractionTest.assertTrue((boolean)interaction.canHandle(spec, request, new MockMappedRecord()));
    }

    public void testEnableAndDisable() {
        MappedRecordInteraction interaction = new MappedRecordInteraction();
        InteractionSpec spec = new InteractionSpec(){};
        MappedRecordInteractionTest.assertTrue((boolean)interaction.canHandle(spec, null, null));
        interaction.disable();
        MappedRecordInteractionTest.assertFalse((boolean)interaction.canHandle(spec, null, null));
        interaction.enable();
        MappedRecordInteractionTest.assertTrue((boolean)interaction.canHandle(spec, null, null));
    }

    public void testExecuteReturnsRecord() throws Exception {
        MappedRecordInteraction interaction = new MappedRecordInteraction();
        InteractionSpec spec = new InteractionSpec(){};
        HashMap<Long, String> expectedRequestMap = new HashMap<Long, String>();
        expectedRequestMap.put(new Long(1L), "value1");
        interaction.setExpectedRequest(expectedRequestMap);
        MappedRecordInteractionTest.assertNull((Object)interaction.execute(spec, new MockIndexedRecord()));
        MockMappedRecord request = new MockMappedRecord();
        request.put(new Long(1L), "value1");
        MockMappedRecord response = (MockMappedRecord)interaction.execute(spec, request);
        MappedRecordInteractionTest.assertEquals((int)0, (int)response.size());
        MockIndexedRecord indexedResponse = new MockIndexedRecord();
        interaction.setResponse(indexedResponse);
        MappedRecordInteractionTest.assertSame((Object)indexedResponse, (Object)interaction.execute(spec, request));
        HashMap<Integer, String> responseMap = new HashMap<Integer, String>();
        responseMap.put(new Integer(1), "value1");
        responseMap.put(new Integer(2), "value2");
        responseMap.put(new Integer(3), "value3");
        interaction.setResponse(responseMap, TestRecord.class);
        interaction.setResponse((Record)null);
        MappedRecordInteractionTest.assertTrue((boolean)(interaction.execute(spec, request) instanceof TestRecord));
        responseMap = new HashMap();
        responseMap.put(new Integer(1), "value1");
        responseMap.put(new Integer(2), "value2");
        responseMap.put(new Integer(3), "value3");
        responseMap.put(new Integer(4), "value4");
        responseMap.put(new Integer(5), "value5");
        interaction.setResponse(responseMap);
        response = (MockMappedRecord)interaction.execute(spec, request);
        MappedRecordInteractionTest.assertTrue((boolean)new HashMap(response).equals(responseMap));
        interaction.setResponse((Record)new TestRecord());
        MappedRecordInteractionTest.assertTrue((boolean)(interaction.execute(spec, request) instanceof TestRecord));
        MappedRecordInteractionTest.assertNull((Object)interaction.execute(spec, new MockMappedRecord()));
        responseMap = new HashMap();
        responseMap.put(new Integer(1), "value1");
        interaction = new MappedRecordInteraction(responseMap, MockMappedRecord.class);
        response = (MockMappedRecord)interaction.execute(spec, request);
        MappedRecordInteractionTest.assertTrue((boolean)new HashMap(response).equals(responseMap));
        responseMap = new HashMap();
        responseMap.put(new Integer(1), "value1");
        responseMap.put(new Integer(2), "value2");
        interaction = new MappedRecordInteraction(responseMap, (Class)null);
        responseMap.put(new Integer(3), "value3");
        response = (MockMappedRecord)interaction.execute(spec, request);
        responseMap.remove(new Integer(3));
        MappedRecordInteractionTest.assertTrue((boolean)new HashMap(response).equals(responseMap));
        interaction.setResponse(indexedResponse);
        MappedRecordInteractionTest.assertSame((Object)indexedResponse, (Object)interaction.execute(spec, request));
        interaction.setResponse((Record)null);
        response = (MockMappedRecord)interaction.execute(spec, request);
        MappedRecordInteractionTest.assertTrue((boolean)new HashMap(response).equals(responseMap));
    }

    public void testExecuteReturnsBoolean() throws Exception {
        MappedRecordInteraction interaction = new MappedRecordInteraction();
        InteractionSpec spec = new InteractionSpec(){};
        HashMap<Long, String> expectedRequestMap = new HashMap<Long, String>();
        expectedRequestMap.put(new Long(1L), "value1");
        interaction.setExpectedRequest(expectedRequestMap);
        MappedRecordInteractionTest.assertFalse((boolean)interaction.execute(spec, new MockIndexedRecord(), null));
        MockMappedRecord request = new MockMappedRecord();
        request.put(new Long(1L), "value1");
        MappedRecordInteractionTest.assertTrue((boolean)interaction.execute(spec, request, null));
        MockMappedRecord response = new MockMappedRecord();
        MappedRecordInteractionTest.assertTrue((boolean)interaction.execute(spec, request, response));
        MappedRecordInteractionTest.assertEquals((int)0, (int)response.size());
        HashMap<Integer, String> responseMap = new HashMap<Integer, String>();
        responseMap.put(new Integer(1), "value1");
        responseMap.put(new Integer(2), "value1");
        responseMap.put(new Integer(3), "value3");
        interaction.setResponse(responseMap);
        MappedRecordInteractionTest.assertTrue((boolean)interaction.execute(spec, request, response));
        MappedRecordInteractionTest.assertTrue((boolean)new HashMap(response).equals(responseMap));
        MappedRecordInteractionTest.assertFalse((boolean)interaction.execute(spec, request, new MockIndexedRecord()));
        MappedRecordInteractionTest.assertTrue((boolean)interaction.execute(spec, request, (Record)new TestRecord()));
        interaction.setResponse((Map)null);
        interaction.setResponse((Record)new TestRecord());
        response = new MockMappedRecord();
        MappedRecordInteractionTest.assertTrue((boolean)interaction.execute(spec, request, response));
        MappedRecordInteractionTest.assertEquals((int)0, (int)response.size());
        responseMap = new HashMap();
        responseMap.put(new Integer(1), "value1");
        interaction = new MappedRecordInteraction(null, responseMap);
        MappedRecordInteractionTest.assertTrue((boolean)interaction.execute(spec, request, response));
        MappedRecordInteractionTest.assertTrue((boolean)new HashMap(response).equals(responseMap));
        interaction.setResponse((Record)new TestRecord());
        MappedRecordInteractionTest.assertTrue((boolean)interaction.execute(spec, request, response));
        MappedRecordInteractionTest.assertTrue((boolean)new HashMap(response).equals(responseMap));
        responseMap = new HashMap();
        responseMap.put(new Integer(2), "value2");
        interaction.setResponse(responseMap);
        MappedRecordInteractionTest.assertTrue((boolean)interaction.execute(spec, request, response));
        MappedRecordInteractionTest.assertTrue((boolean)new HashMap(response).equals(responseMap));
    }

    public static class TestRecord
    implements MappedRecord {
        public String getRecordName() {
            return "";
        }

        public String getRecordShortDescription() {
            return "";
        }

        public void setRecordName(String name) {
        }

        public void setRecordShortDescription(String description) {
        }

        public void clear() {
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public Set entrySet() {
            return null;
        }

        public Object get(Object key) {
            return null;
        }

        public boolean isEmpty() {
            return false;
        }

        public Set keySet() {
            return null;
        }

        public Object put(Object key, Object value) {
            return null;
        }

        public void putAll(Map map) {
        }

        public Object remove(Object key) {
            return null;
        }

        public int size() {
            return 0;
        }

        public Collection values() {
            return null;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

