/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.web;

import com.mockrunner.mock.web.MockExpressionEvaluator;
import com.mockrunner.mock.web.MockFunctionMapper;
import com.mockrunner.mock.web.MockVariableResolver;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.Expression;
import javax.servlet.jsp.el.VariableResolver;
import junit.framework.TestCase;

public class MockExpressionEvaluatorTest
extends TestCase {
    private MockExpressionEvaluator evaluator;

    protected void setUp() throws Exception {
        super.setUp();
        this.evaluator = new MockExpressionEvaluator();
    }

    public void testEvaluateFailure() throws Exception {
        try {
            this.evaluator.evaluate("myexp", String.class, new MockVariableResolver(), new MockFunctionMapper());
            MockExpressionEvaluatorTest.fail();
        }
        catch (ELException exc) {
            // empty catch block
        }
        this.evaluator.addObject("myexp", new Integer(3));
        try {
            this.evaluator.evaluate("myexp", String.class, new MockVariableResolver(), new MockFunctionMapper());
            MockExpressionEvaluatorTest.fail();
        }
        catch (ELException eLException) {
            // empty catch block
        }
    }

    public void testEvaluateOk() throws Exception {
        this.evaluator.addObject("myexp", new Integer(3));
        MockExpressionEvaluatorTest.assertEquals((Object)new Integer(3), (Object)this.evaluator.evaluate("myexp", Integer.class, null, null));
        Object object = new Object();
        this.evaluator.addObject("myexp", object);
        MockExpressionEvaluatorTest.assertEquals((Object)object, (Object)this.evaluator.evaluate("myexp", Object.class, null, null));
    }

    public void testExpression() throws Exception {
        Expression expression = this.evaluator.parseExpression("myexp", String.class, null);
        try {
            expression.evaluate(null);
            MockExpressionEvaluatorTest.fail();
        }
        catch (ELException exc) {
            // empty catch block
        }
        this.evaluator.addObject("myexp", "abc");
        MockExpressionEvaluatorTest.assertEquals((Object)"abc", (Object)expression.evaluate(null));
        this.evaluator.addObject("myexp", new Character('a'));
        try {
            expression.evaluate((VariableResolver)new MockVariableResolver());
            MockExpressionEvaluatorTest.fail();
        }
        catch (ELException eLException) {
            // empty catch block
        }
    }

    public void testDummy() {
    }
}

