/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.web;

import com.mockrunner.mock.web.MockFilterChain;
import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import junit.framework.TestCase;

public class MockFilterChainTest
extends TestCase {
    private MockFilterChain chain;

    protected void setUp() throws Exception {
        super.setUp();
        this.chain = new MockFilterChain();
    }

    public void testNoServlet() throws Exception {
        this.chain.doFilter(null, null);
        TestServlet servlet = new TestServlet();
        this.chain.setServlet((Servlet)servlet);
        this.chain.doFilter(null, null);
        MockFilterChainTest.assertTrue((boolean)servlet.wasServiceCalled());
        this.chain.release();
        servlet.reset();
        this.chain.doFilter(null, null);
        MockFilterChainTest.assertFalse((boolean)servlet.wasServiceCalled());
    }

    public void testFilterInstance() throws Exception {
        try {
            this.chain.addFilter(String.class);
            MockFilterChainTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.chain.addFilter(TestFilter.class);
    }

    public void testDoFilter() throws Exception {
        TestFilter filter1 = new TestFilter();
        TestFilter filter2 = new TestFilter();
        this.chain.addFilter(filter1);
        this.chain.addFilter(filter2);
        TestServlet servlet = new TestServlet();
        this.chain.setServlet((Servlet)servlet);
        this.chain.doFilter(null, null);
        MockFilterChainTest.assertTrue((boolean)filter1.wasDoFilterCalled());
        MockFilterChainTest.assertTrue((boolean)filter2.wasDoFilterCalled());
        MockFilterChainTest.assertTrue((boolean)servlet.wasServiceCalled());
        filter1.reset();
        filter2.reset();
        servlet.reset();
        filter1.setDoChain(false);
        this.chain.doFilter(null, null);
        MockFilterChainTest.assertTrue((boolean)filter1.wasDoFilterCalled());
        MockFilterChainTest.assertFalse((boolean)filter2.wasDoFilterCalled());
        MockFilterChainTest.assertFalse((boolean)servlet.wasServiceCalled());
        MockFilterChainTest.assertNull((Object)this.chain.getLastRequest());
        MockFilterChainTest.assertNull((Object)this.chain.getLastResponse());
    }

    public void testRequestAndResponseList() throws Exception {
        TestFilter filter1 = new TestFilter();
        TestFilter filter2 = new TestFilter();
        TestFilter filter3 = new TestFilter();
        MockHttpServletRequest request1 = new MockHttpServletRequest();
        MockHttpServletRequest request3 = new MockHttpServletRequest();
        MockHttpServletResponse response1 = new MockHttpServletResponse();
        MockHttpServletResponse response2 = new MockHttpServletResponse();
        filter3.setRequest((ServletRequest)request3);
        filter2.setResponse((ServletResponse)response2);
        this.chain.addFilter(filter1);
        this.chain.addFilter(filter2);
        this.chain.addFilter(filter3);
        TestServlet servlet = new TestServlet();
        this.chain.setServlet((Servlet)servlet);
        this.chain.doFilter((ServletRequest)request1, (ServletResponse)response1);
        MockFilterChainTest.assertEquals((int)4, (int)this.chain.getRequestList().size());
        MockFilterChainTest.assertEquals((int)4, (int)this.chain.getResponseList().size());
        MockFilterChainTest.assertSame((Object)request1, this.chain.getRequestList().get(0));
        MockFilterChainTest.assertSame((Object)request1, this.chain.getRequestList().get(1));
        MockFilterChainTest.assertSame((Object)request1, this.chain.getRequestList().get(2));
        MockFilterChainTest.assertSame((Object)request3, this.chain.getRequestList().get(3));
        MockFilterChainTest.assertSame((Object)request3, (Object)this.chain.getLastRequest());
        MockFilterChainTest.assertSame((Object)response1, this.chain.getResponseList().get(0));
        MockFilterChainTest.assertSame((Object)response1, this.chain.getResponseList().get(1));
        MockFilterChainTest.assertSame((Object)response2, this.chain.getResponseList().get(2));
        MockFilterChainTest.assertSame((Object)response2, this.chain.getResponseList().get(3));
        MockFilterChainTest.assertSame((Object)response2, (Object)this.chain.getLastResponse());
    }

    public void testLastRequestAndResponse() throws Exception {
        TestFilter filter1 = new TestFilter();
        TestFilter filter2 = new TestFilter();
        this.chain.addFilter(filter1);
        this.chain.addFilter(filter2);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChainTest.assertNull((Object)this.chain.getLastRequest());
        MockFilterChainTest.assertNull((Object)this.chain.getLastResponse());
        this.chain.doFilter((ServletRequest)request, (ServletResponse)response);
        MockFilterChainTest.assertSame((Object)request, (Object)this.chain.getLastRequest());
        MockFilterChainTest.assertSame((Object)response, (Object)this.chain.getLastResponse());
    }

    public void testReset() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        SkipTestFilter filter1 = new SkipTestFilter();
        TestFilter filter2 = new TestFilter();
        this.chain.addFilter(filter1);
        this.chain.addFilter(filter2);
        this.chain.doFilter((ServletRequest)request, (ServletResponse)response);
        MockFilterChainTest.assertFalse((boolean)filter2.wasDoFilterCalled());
        this.chain.reset();
        this.chain.doFilter((ServletRequest)request, (ServletResponse)response);
        MockFilterChainTest.assertFalse((boolean)filter2.wasDoFilterCalled());
    }

    public static class TestServlet
    extends HttpServlet {
        private boolean serviceCalled = false;

        public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            this.serviceCalled = true;
        }

        public void reset() {
            this.serviceCalled = false;
        }

        public boolean wasServiceCalled() {
            return this.serviceCalled;
        }
    }

    public static class TestFilter
    implements Filter {
        private boolean doFilterCalled = false;
        private boolean doChain = true;
        private ServletRequest request;
        private ServletResponse response;

        public void init(FilterConfig config) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.doFilterCalled = true;
            if (this.doChain) {
                if (null != this.request) {
                    request = this.request;
                }
                if (null != this.response) {
                    response = this.response;
                }
                chain.doFilter(request, response);
            }
        }

        public void destroy() {
        }

        public void setDoChain(boolean doChain) {
            this.doChain = doChain;
        }

        public void setRequest(ServletRequest request) {
            this.request = request;
        }

        public void setResponse(ServletResponse response) {
            this.response = response;
        }

        public boolean wasDoFilterCalled() {
            return this.doFilterCalled;
        }

        public void reset() {
            this.doFilterCalled = false;
        }
    }

    public static class SkipTestFilter
    implements Filter {
        public void init(FilterConfig config) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        }

        public void destroy() {
        }
    }
}

